package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class PaymentDraft {
  private MoneyInput amountPlanned;

  private PaymentMethodInfoInput paymentMethodInfo;

  private CustomFieldsDraft custom;

  private String key;

  private ResourceIdentifierInput customer;

  private String anonymousId;

  private String interfaceId;

  private PaymentStatusInput paymentStatus;

  private List<TransactionDraft> transactions;

  private List<CustomFieldsDraft> interfaceInteractions;

  public PaymentDraft() {
  }

  public PaymentDraft(MoneyInput amountPlanned, PaymentMethodInfoInput paymentMethodInfo,
      CustomFieldsDraft custom, String key, ResourceIdentifierInput customer, String anonymousId,
      String interfaceId, PaymentStatusInput paymentStatus, List<TransactionDraft> transactions,
      List<CustomFieldsDraft> interfaceInteractions) {
    this.amountPlanned = amountPlanned;
    this.paymentMethodInfo = paymentMethodInfo;
    this.custom = custom;
    this.key = key;
    this.customer = customer;
    this.anonymousId = anonymousId;
    this.interfaceId = interfaceId;
    this.paymentStatus = paymentStatus;
    this.transactions = transactions;
    this.interfaceInteractions = interfaceInteractions;
  }

  public MoneyInput getAmountPlanned() {
    return amountPlanned;
  }

  public void setAmountPlanned(MoneyInput amountPlanned) {
    this.amountPlanned = amountPlanned;
  }

  public PaymentMethodInfoInput getPaymentMethodInfo() {
    return paymentMethodInfo;
  }

  public void setPaymentMethodInfo(PaymentMethodInfoInput paymentMethodInfo) {
    this.paymentMethodInfo = paymentMethodInfo;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getCustomer() {
    return customer;
  }

  public void setCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public String getInterfaceId() {
    return interfaceId;
  }

  public void setInterfaceId(String interfaceId) {
    this.interfaceId = interfaceId;
  }

  public PaymentStatusInput getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(PaymentStatusInput paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  public List<TransactionDraft> getTransactions() {
    return transactions;
  }

  public void setTransactions(List<TransactionDraft> transactions) {
    this.transactions = transactions;
  }

  public List<CustomFieldsDraft> getInterfaceInteractions() {
    return interfaceInteractions;
  }

  public void setInterfaceInteractions(List<CustomFieldsDraft> interfaceInteractions) {
    this.interfaceInteractions = interfaceInteractions;
  }

  @Override
  public String toString() {
    return "PaymentDraft{amountPlanned='" + amountPlanned + "', paymentMethodInfo='" + paymentMethodInfo + "', custom='" + custom + "', key='" + key + "', customer='" + customer + "', anonymousId='" + anonymousId + "', interfaceId='" + interfaceId + "', paymentStatus='" + paymentStatus + "', transactions='" + transactions + "', interfaceInteractions='" + interfaceInteractions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentDraft that = (PaymentDraft) o;
    return Objects.equals(amountPlanned, that.amountPlanned) &&
        Objects.equals(paymentMethodInfo, that.paymentMethodInfo) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(key, that.key) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(interfaceId, that.interfaceId) &&
        Objects.equals(paymentStatus, that.paymentStatus) &&
        Objects.equals(transactions, that.transactions) &&
        Objects.equals(interfaceInteractions, that.interfaceInteractions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountPlanned, paymentMethodInfo, custom, key, customer, anonymousId, interfaceId, paymentStatus, transactions, interfaceInteractions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput amountPlanned;

    private PaymentMethodInfoInput paymentMethodInfo;

    private CustomFieldsDraft custom;

    private String key;

    private ResourceIdentifierInput customer;

    private String anonymousId;

    private String interfaceId;

    private PaymentStatusInput paymentStatus;

    private List<TransactionDraft> transactions;

    private List<CustomFieldsDraft> interfaceInteractions;

    public PaymentDraft build() {
      PaymentDraft result = new PaymentDraft();
      result.amountPlanned = this.amountPlanned;
      result.paymentMethodInfo = this.paymentMethodInfo;
      result.custom = this.custom;
      result.key = this.key;
      result.customer = this.customer;
      result.anonymousId = this.anonymousId;
      result.interfaceId = this.interfaceId;
      result.paymentStatus = this.paymentStatus;
      result.transactions = this.transactions;
      result.interfaceInteractions = this.interfaceInteractions;
      return result;
    }

    public Builder amountPlanned(MoneyInput amountPlanned) {
      this.amountPlanned = amountPlanned;
      return this;
    }

    public Builder paymentMethodInfo(PaymentMethodInfoInput paymentMethodInfo) {
      this.paymentMethodInfo = paymentMethodInfo;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder customer(ResourceIdentifierInput customer) {
      this.customer = customer;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder interfaceId(String interfaceId) {
      this.interfaceId = interfaceId;
      return this;
    }

    public Builder paymentStatus(PaymentStatusInput paymentStatus) {
      this.paymentStatus = paymentStatus;
      return this;
    }

    public Builder transactions(List<TransactionDraft> transactions) {
      this.transactions = transactions;
      return this;
    }

    public Builder interfaceInteractions(List<CustomFieldsDraft> interfaceInteractions) {
      this.interfaceInteractions = interfaceInteractions;
      return this;
    }
  }
}
