package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class PaymentMethodInfo {
  private String paymentInterface;

  private String method;

  private String name;

  private List<LocalizedString> nameAllLocales;

  public PaymentMethodInfo() {
  }

  public PaymentMethodInfo(String paymentInterface, String method, String name,
      List<LocalizedString> nameAllLocales) {
    this.paymentInterface = paymentInterface;
    this.method = method;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
  }

  public String getPaymentInterface() {
    return paymentInterface;
  }

  public void setPaymentInterface(String paymentInterface) {
    this.paymentInterface = paymentInterface;
  }

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  @Override
  public String toString() {
    return "PaymentMethodInfo{paymentInterface='" + paymentInterface + "', method='" + method + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentMethodInfo that = (PaymentMethodInfo) o;
    return Objects.equals(paymentInterface, that.paymentInterface) &&
        Objects.equals(method, that.method) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentInterface, method, name, nameAllLocales);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String paymentInterface;

    private String method;

    private String name;

    private List<LocalizedString> nameAllLocales;

    public PaymentMethodInfo build() {
      PaymentMethodInfo result = new PaymentMethodInfo();
      result.paymentInterface = this.paymentInterface;
      result.method = this.method;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      return result;
    }

    public Builder paymentInterface(String paymentInterface) {
      this.paymentInterface = paymentInterface;
      return this;
    }

    public Builder method(String method) {
      this.method = method;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }
  }
}
