package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class PaymentMethodInfoInput {
  private String paymentInterface;

  private String method;

  private List<LocalizedStringItemInputType> name;

  public PaymentMethodInfoInput() {
  }

  public PaymentMethodInfoInput(String paymentInterface, String method,
      List<LocalizedStringItemInputType> name) {
    this.paymentInterface = paymentInterface;
    this.method = method;
    this.name = name;
  }

  public String getPaymentInterface() {
    return paymentInterface;
  }

  public void setPaymentInterface(String paymentInterface) {
    this.paymentInterface = paymentInterface;
  }

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "PaymentMethodInfoInput{paymentInterface='" + paymentInterface + "', method='" + method + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentMethodInfoInput that = (PaymentMethodInfoInput) o;
    return Objects.equals(paymentInterface, that.paymentInterface) &&
        Objects.equals(method, that.method) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentInterface, method, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String paymentInterface;

    private String method;

    private List<LocalizedStringItemInputType> name;

    public PaymentMethodInfoInput build() {
      PaymentMethodInfoInput result = new PaymentMethodInfoInput();
      result.paymentInterface = this.paymentInterface;
      result.method = this.method;
      result.name = this.name;
      return result;
    }

    public Builder paymentInterface(String paymentInterface) {
      this.paymentInterface = paymentInterface;
      return this;
    }

    public Builder method(String method) {
      this.method = method;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }
  }
}
