package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PaymentStatus {
  private String interfaceCode;

  private String interfaceText;

  private Reference stateRef;

  private State state;

  public PaymentStatus() {
  }

  public PaymentStatus(String interfaceCode, String interfaceText, Reference stateRef,
      State state) {
    this.interfaceCode = interfaceCode;
    this.interfaceText = interfaceText;
    this.stateRef = stateRef;
    this.state = state;
  }

  public String getInterfaceCode() {
    return interfaceCode;
  }

  public void setInterfaceCode(String interfaceCode) {
    this.interfaceCode = interfaceCode;
  }

  public String getInterfaceText() {
    return interfaceText;
  }

  public void setInterfaceText(String interfaceText) {
    this.interfaceText = interfaceText;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "PaymentStatus{interfaceCode='" + interfaceCode + "', interfaceText='" + interfaceText + "', stateRef='" + stateRef + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentStatus that = (PaymentStatus) o;
    return Objects.equals(interfaceCode, that.interfaceCode) &&
        Objects.equals(interfaceText, that.interfaceText) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interfaceCode, interfaceText, stateRef, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String interfaceCode;

    private String interfaceText;

    private Reference stateRef;

    private State state;

    public PaymentStatus build() {
      PaymentStatus result = new PaymentStatus();
      result.interfaceCode = this.interfaceCode;
      result.interfaceText = this.interfaceText;
      result.stateRef = this.stateRef;
      result.state = this.state;
      return result;
    }

    public Builder interfaceCode(String interfaceCode) {
      this.interfaceCode = interfaceCode;
      return this;
    }

    public Builder interfaceText(String interfaceText) {
      this.interfaceText = interfaceText;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }
  }
}
