package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PaymentStatusInput {
  private String interfaceCode;

  private String interfaceText;

  private ResourceIdentifierInput state;

  public PaymentStatusInput() {
  }

  public PaymentStatusInput(String interfaceCode, String interfaceText,
      ResourceIdentifierInput state) {
    this.interfaceCode = interfaceCode;
    this.interfaceText = interfaceText;
    this.state = state;
  }

  public String getInterfaceCode() {
    return interfaceCode;
  }

  public void setInterfaceCode(String interfaceCode) {
    this.interfaceCode = interfaceCode;
  }

  public String getInterfaceText() {
    return interfaceText;
  }

  public void setInterfaceText(String interfaceText) {
    this.interfaceText = interfaceText;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "PaymentStatusInput{interfaceCode='" + interfaceCode + "', interfaceText='" + interfaceText + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentStatusInput that = (PaymentStatusInput) o;
    return Objects.equals(interfaceCode, that.interfaceCode) &&
        Objects.equals(interfaceText, that.interfaceText) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interfaceCode, interfaceText, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String interfaceCode;

    private String interfaceText;

    private ResourceIdentifierInput state;

    public PaymentStatusInput build() {
      PaymentStatusInput result = new PaymentStatusInput();
      result.interfaceCode = this.interfaceCode;
      result.interfaceText = this.interfaceText;
      result.state = this.state;
      return result;
    }

    public Builder interfaceCode(String interfaceCode) {
      this.interfaceCode = interfaceCode;
      return this;
    }

    public Builder interfaceText(String interfaceText) {
      this.interfaceText = interfaceText;
      return this;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }
  }
}
