package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PaymentUpdateAction {
  private AddPaymentInterfaceInteraction addInterfaceInteraction;

  private AddPaymentTransaction addTransaction;

  private ChangePaymentAmountPlanned changeAmountPlanned;

  private ChangePaymentTransactionInteractionId changeTransactionInteractionId;

  private ChangePaymentTransactionState changeTransactionState;

  private ChangePaymentTransactionTimestamp changeTransactionTimestamp;

  private SetPaymentAmountPaid setAmountPaid;

  private SetPaymentAmountRefunded setAmountRefunded;

  private SetPaymentAnonymousId setAnonymousId;

  private SetPaymentAuthorization setAuthorization;

  private SetPaymentCustomField setCustomField;

  private SetPaymentCustomType setCustomType;

  private SetPaymentCustomer setCustomer;

  private SetPaymentExternalId setExternalId;

  private SetPaymentInterfaceId setInterfaceId;

  private SetPaymentKey setKey;

  private SetPaymentMethodInfoInterface setMethodInfoInterface;

  private SetPaymentMethodInfoMethod setMethodInfoMethod;

  private SetPaymentMethodInfoName setMethodInfoName;

  private SetPaymentStatusInterfaceCode setStatusInterfaceCode;

  private SetPaymentStatusInterfaceText setStatusInterfaceText;

  private SetPaymentTransactionCustomField setTransactionCustomField;

  private SetPaymentTransactionCustomType setTransactionCustomType;

  private TransitionPaymentState transitionState;

  public PaymentUpdateAction() {
  }

  public PaymentUpdateAction(AddPaymentInterfaceInteraction addInterfaceInteraction,
      AddPaymentTransaction addTransaction, ChangePaymentAmountPlanned changeAmountPlanned,
      ChangePaymentTransactionInteractionId changeTransactionInteractionId,
      ChangePaymentTransactionState changeTransactionState,
      ChangePaymentTransactionTimestamp changeTransactionTimestamp,
      SetPaymentAmountPaid setAmountPaid, SetPaymentAmountRefunded setAmountRefunded,
      SetPaymentAnonymousId setAnonymousId, SetPaymentAuthorization setAuthorization,
      SetPaymentCustomField setCustomField, SetPaymentCustomType setCustomType,
      SetPaymentCustomer setCustomer, SetPaymentExternalId setExternalId,
      SetPaymentInterfaceId setInterfaceId, SetPaymentKey setKey,
      SetPaymentMethodInfoInterface setMethodInfoInterface,
      SetPaymentMethodInfoMethod setMethodInfoMethod, SetPaymentMethodInfoName setMethodInfoName,
      SetPaymentStatusInterfaceCode setStatusInterfaceCode,
      SetPaymentStatusInterfaceText setStatusInterfaceText,
      SetPaymentTransactionCustomField setTransactionCustomField,
      SetPaymentTransactionCustomType setTransactionCustomType,
      TransitionPaymentState transitionState) {
    this.addInterfaceInteraction = addInterfaceInteraction;
    this.addTransaction = addTransaction;
    this.changeAmountPlanned = changeAmountPlanned;
    this.changeTransactionInteractionId = changeTransactionInteractionId;
    this.changeTransactionState = changeTransactionState;
    this.changeTransactionTimestamp = changeTransactionTimestamp;
    this.setAmountPaid = setAmountPaid;
    this.setAmountRefunded = setAmountRefunded;
    this.setAnonymousId = setAnonymousId;
    this.setAuthorization = setAuthorization;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setCustomer = setCustomer;
    this.setExternalId = setExternalId;
    this.setInterfaceId = setInterfaceId;
    this.setKey = setKey;
    this.setMethodInfoInterface = setMethodInfoInterface;
    this.setMethodInfoMethod = setMethodInfoMethod;
    this.setMethodInfoName = setMethodInfoName;
    this.setStatusInterfaceCode = setStatusInterfaceCode;
    this.setStatusInterfaceText = setStatusInterfaceText;
    this.setTransactionCustomField = setTransactionCustomField;
    this.setTransactionCustomType = setTransactionCustomType;
    this.transitionState = transitionState;
  }

  public AddPaymentInterfaceInteraction getAddInterfaceInteraction() {
    return addInterfaceInteraction;
  }

  public void setAddInterfaceInteraction(AddPaymentInterfaceInteraction addInterfaceInteraction) {
    this.addInterfaceInteraction = addInterfaceInteraction;
  }

  public AddPaymentTransaction getAddTransaction() {
    return addTransaction;
  }

  public void setAddTransaction(AddPaymentTransaction addTransaction) {
    this.addTransaction = addTransaction;
  }

  public ChangePaymentAmountPlanned getChangeAmountPlanned() {
    return changeAmountPlanned;
  }

  public void setChangeAmountPlanned(ChangePaymentAmountPlanned changeAmountPlanned) {
    this.changeAmountPlanned = changeAmountPlanned;
  }

  public ChangePaymentTransactionInteractionId getChangeTransactionInteractionId() {
    return changeTransactionInteractionId;
  }

  public void setChangeTransactionInteractionId(
      ChangePaymentTransactionInteractionId changeTransactionInteractionId) {
    this.changeTransactionInteractionId = changeTransactionInteractionId;
  }

  public ChangePaymentTransactionState getChangeTransactionState() {
    return changeTransactionState;
  }

  public void setChangeTransactionState(ChangePaymentTransactionState changeTransactionState) {
    this.changeTransactionState = changeTransactionState;
  }

  public ChangePaymentTransactionTimestamp getChangeTransactionTimestamp() {
    return changeTransactionTimestamp;
  }

  public void setChangeTransactionTimestamp(
      ChangePaymentTransactionTimestamp changeTransactionTimestamp) {
    this.changeTransactionTimestamp = changeTransactionTimestamp;
  }

  public SetPaymentAmountPaid getSetAmountPaid() {
    return setAmountPaid;
  }

  public void setSetAmountPaid(SetPaymentAmountPaid setAmountPaid) {
    this.setAmountPaid = setAmountPaid;
  }

  public SetPaymentAmountRefunded getSetAmountRefunded() {
    return setAmountRefunded;
  }

  public void setSetAmountRefunded(SetPaymentAmountRefunded setAmountRefunded) {
    this.setAmountRefunded = setAmountRefunded;
  }

  public SetPaymentAnonymousId getSetAnonymousId() {
    return setAnonymousId;
  }

  public void setSetAnonymousId(SetPaymentAnonymousId setAnonymousId) {
    this.setAnonymousId = setAnonymousId;
  }

  public SetPaymentAuthorization getSetAuthorization() {
    return setAuthorization;
  }

  public void setSetAuthorization(SetPaymentAuthorization setAuthorization) {
    this.setAuthorization = setAuthorization;
  }

  public SetPaymentCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetPaymentCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetPaymentCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetPaymentCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetPaymentCustomer getSetCustomer() {
    return setCustomer;
  }

  public void setSetCustomer(SetPaymentCustomer setCustomer) {
    this.setCustomer = setCustomer;
  }

  public SetPaymentExternalId getSetExternalId() {
    return setExternalId;
  }

  public void setSetExternalId(SetPaymentExternalId setExternalId) {
    this.setExternalId = setExternalId;
  }

  public SetPaymentInterfaceId getSetInterfaceId() {
    return setInterfaceId;
  }

  public void setSetInterfaceId(SetPaymentInterfaceId setInterfaceId) {
    this.setInterfaceId = setInterfaceId;
  }

  public SetPaymentKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetPaymentKey setKey) {
    this.setKey = setKey;
  }

  public SetPaymentMethodInfoInterface getSetMethodInfoInterface() {
    return setMethodInfoInterface;
  }

  public void setSetMethodInfoInterface(SetPaymentMethodInfoInterface setMethodInfoInterface) {
    this.setMethodInfoInterface = setMethodInfoInterface;
  }

  public SetPaymentMethodInfoMethod getSetMethodInfoMethod() {
    return setMethodInfoMethod;
  }

  public void setSetMethodInfoMethod(SetPaymentMethodInfoMethod setMethodInfoMethod) {
    this.setMethodInfoMethod = setMethodInfoMethod;
  }

  public SetPaymentMethodInfoName getSetMethodInfoName() {
    return setMethodInfoName;
  }

  public void setSetMethodInfoName(SetPaymentMethodInfoName setMethodInfoName) {
    this.setMethodInfoName = setMethodInfoName;
  }

  public SetPaymentStatusInterfaceCode getSetStatusInterfaceCode() {
    return setStatusInterfaceCode;
  }

  public void setSetStatusInterfaceCode(SetPaymentStatusInterfaceCode setStatusInterfaceCode) {
    this.setStatusInterfaceCode = setStatusInterfaceCode;
  }

  public SetPaymentStatusInterfaceText getSetStatusInterfaceText() {
    return setStatusInterfaceText;
  }

  public void setSetStatusInterfaceText(SetPaymentStatusInterfaceText setStatusInterfaceText) {
    this.setStatusInterfaceText = setStatusInterfaceText;
  }

  public SetPaymentTransactionCustomField getSetTransactionCustomField() {
    return setTransactionCustomField;
  }

  public void setSetTransactionCustomField(
      SetPaymentTransactionCustomField setTransactionCustomField) {
    this.setTransactionCustomField = setTransactionCustomField;
  }

  public SetPaymentTransactionCustomType getSetTransactionCustomType() {
    return setTransactionCustomType;
  }

  public void setSetTransactionCustomType(
      SetPaymentTransactionCustomType setTransactionCustomType) {
    this.setTransactionCustomType = setTransactionCustomType;
  }

  public TransitionPaymentState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionPaymentState transitionState) {
    this.transitionState = transitionState;
  }

  @Override
  public String toString() {
    return "PaymentUpdateAction{addInterfaceInteraction='" + addInterfaceInteraction + "', addTransaction='" + addTransaction + "', changeAmountPlanned='" + changeAmountPlanned + "', changeTransactionInteractionId='" + changeTransactionInteractionId + "', changeTransactionState='" + changeTransactionState + "', changeTransactionTimestamp='" + changeTransactionTimestamp + "', setAmountPaid='" + setAmountPaid + "', setAmountRefunded='" + setAmountRefunded + "', setAnonymousId='" + setAnonymousId + "', setAuthorization='" + setAuthorization + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setCustomer='" + setCustomer + "', setExternalId='" + setExternalId + "', setInterfaceId='" + setInterfaceId + "', setKey='" + setKey + "', setMethodInfoInterface='" + setMethodInfoInterface + "', setMethodInfoMethod='" + setMethodInfoMethod + "', setMethodInfoName='" + setMethodInfoName + "', setStatusInterfaceCode='" + setStatusInterfaceCode + "', setStatusInterfaceText='" + setStatusInterfaceText + "', setTransactionCustomField='" + setTransactionCustomField + "', setTransactionCustomType='" + setTransactionCustomType + "', transitionState='" + transitionState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentUpdateAction that = (PaymentUpdateAction) o;
    return Objects.equals(addInterfaceInteraction, that.addInterfaceInteraction) &&
        Objects.equals(addTransaction, that.addTransaction) &&
        Objects.equals(changeAmountPlanned, that.changeAmountPlanned) &&
        Objects.equals(changeTransactionInteractionId, that.changeTransactionInteractionId) &&
        Objects.equals(changeTransactionState, that.changeTransactionState) &&
        Objects.equals(changeTransactionTimestamp, that.changeTransactionTimestamp) &&
        Objects.equals(setAmountPaid, that.setAmountPaid) &&
        Objects.equals(setAmountRefunded, that.setAmountRefunded) &&
        Objects.equals(setAnonymousId, that.setAnonymousId) &&
        Objects.equals(setAuthorization, that.setAuthorization) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomer, that.setCustomer) &&
        Objects.equals(setExternalId, that.setExternalId) &&
        Objects.equals(setInterfaceId, that.setInterfaceId) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setMethodInfoInterface, that.setMethodInfoInterface) &&
        Objects.equals(setMethodInfoMethod, that.setMethodInfoMethod) &&
        Objects.equals(setMethodInfoName, that.setMethodInfoName) &&
        Objects.equals(setStatusInterfaceCode, that.setStatusInterfaceCode) &&
        Objects.equals(setStatusInterfaceText, that.setStatusInterfaceText) &&
        Objects.equals(setTransactionCustomField, that.setTransactionCustomField) &&
        Objects.equals(setTransactionCustomType, that.setTransactionCustomType) &&
        Objects.equals(transitionState, that.transitionState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addInterfaceInteraction, addTransaction, changeAmountPlanned, changeTransactionInteractionId, changeTransactionState, changeTransactionTimestamp, setAmountPaid, setAmountRefunded, setAnonymousId, setAuthorization, setCustomField, setCustomType, setCustomer, setExternalId, setInterfaceId, setKey, setMethodInfoInterface, setMethodInfoMethod, setMethodInfoName, setStatusInterfaceCode, setStatusInterfaceText, setTransactionCustomField, setTransactionCustomType, transitionState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddPaymentInterfaceInteraction addInterfaceInteraction;

    private AddPaymentTransaction addTransaction;

    private ChangePaymentAmountPlanned changeAmountPlanned;

    private ChangePaymentTransactionInteractionId changeTransactionInteractionId;

    private ChangePaymentTransactionState changeTransactionState;

    private ChangePaymentTransactionTimestamp changeTransactionTimestamp;

    private SetPaymentAmountPaid setAmountPaid;

    private SetPaymentAmountRefunded setAmountRefunded;

    private SetPaymentAnonymousId setAnonymousId;

    private SetPaymentAuthorization setAuthorization;

    private SetPaymentCustomField setCustomField;

    private SetPaymentCustomType setCustomType;

    private SetPaymentCustomer setCustomer;

    private SetPaymentExternalId setExternalId;

    private SetPaymentInterfaceId setInterfaceId;

    private SetPaymentKey setKey;

    private SetPaymentMethodInfoInterface setMethodInfoInterface;

    private SetPaymentMethodInfoMethod setMethodInfoMethod;

    private SetPaymentMethodInfoName setMethodInfoName;

    private SetPaymentStatusInterfaceCode setStatusInterfaceCode;

    private SetPaymentStatusInterfaceText setStatusInterfaceText;

    private SetPaymentTransactionCustomField setTransactionCustomField;

    private SetPaymentTransactionCustomType setTransactionCustomType;

    private TransitionPaymentState transitionState;

    public PaymentUpdateAction build() {
      PaymentUpdateAction result = new PaymentUpdateAction();
      result.addInterfaceInteraction = this.addInterfaceInteraction;
      result.addTransaction = this.addTransaction;
      result.changeAmountPlanned = this.changeAmountPlanned;
      result.changeTransactionInteractionId = this.changeTransactionInteractionId;
      result.changeTransactionState = this.changeTransactionState;
      result.changeTransactionTimestamp = this.changeTransactionTimestamp;
      result.setAmountPaid = this.setAmountPaid;
      result.setAmountRefunded = this.setAmountRefunded;
      result.setAnonymousId = this.setAnonymousId;
      result.setAuthorization = this.setAuthorization;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setCustomer = this.setCustomer;
      result.setExternalId = this.setExternalId;
      result.setInterfaceId = this.setInterfaceId;
      result.setKey = this.setKey;
      result.setMethodInfoInterface = this.setMethodInfoInterface;
      result.setMethodInfoMethod = this.setMethodInfoMethod;
      result.setMethodInfoName = this.setMethodInfoName;
      result.setStatusInterfaceCode = this.setStatusInterfaceCode;
      result.setStatusInterfaceText = this.setStatusInterfaceText;
      result.setTransactionCustomField = this.setTransactionCustomField;
      result.setTransactionCustomType = this.setTransactionCustomType;
      result.transitionState = this.transitionState;
      return result;
    }

    public Builder addInterfaceInteraction(AddPaymentInterfaceInteraction addInterfaceInteraction) {
      this.addInterfaceInteraction = addInterfaceInteraction;
      return this;
    }

    public Builder addTransaction(AddPaymentTransaction addTransaction) {
      this.addTransaction = addTransaction;
      return this;
    }

    public Builder changeAmountPlanned(ChangePaymentAmountPlanned changeAmountPlanned) {
      this.changeAmountPlanned = changeAmountPlanned;
      return this;
    }

    public Builder changeTransactionInteractionId(
        ChangePaymentTransactionInteractionId changeTransactionInteractionId) {
      this.changeTransactionInteractionId = changeTransactionInteractionId;
      return this;
    }

    public Builder changeTransactionState(ChangePaymentTransactionState changeTransactionState) {
      this.changeTransactionState = changeTransactionState;
      return this;
    }

    public Builder changeTransactionTimestamp(
        ChangePaymentTransactionTimestamp changeTransactionTimestamp) {
      this.changeTransactionTimestamp = changeTransactionTimestamp;
      return this;
    }

    public Builder setAmountPaid(SetPaymentAmountPaid setAmountPaid) {
      this.setAmountPaid = setAmountPaid;
      return this;
    }

    public Builder setAmountRefunded(SetPaymentAmountRefunded setAmountRefunded) {
      this.setAmountRefunded = setAmountRefunded;
      return this;
    }

    public Builder setAnonymousId(SetPaymentAnonymousId setAnonymousId) {
      this.setAnonymousId = setAnonymousId;
      return this;
    }

    public Builder setAuthorization(SetPaymentAuthorization setAuthorization) {
      this.setAuthorization = setAuthorization;
      return this;
    }

    public Builder setCustomField(SetPaymentCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetPaymentCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomer(SetPaymentCustomer setCustomer) {
      this.setCustomer = setCustomer;
      return this;
    }

    public Builder setExternalId(SetPaymentExternalId setExternalId) {
      this.setExternalId = setExternalId;
      return this;
    }

    public Builder setInterfaceId(SetPaymentInterfaceId setInterfaceId) {
      this.setInterfaceId = setInterfaceId;
      return this;
    }

    public Builder setKey(SetPaymentKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setMethodInfoInterface(SetPaymentMethodInfoInterface setMethodInfoInterface) {
      this.setMethodInfoInterface = setMethodInfoInterface;
      return this;
    }

    public Builder setMethodInfoMethod(SetPaymentMethodInfoMethod setMethodInfoMethod) {
      this.setMethodInfoMethod = setMethodInfoMethod;
      return this;
    }

    public Builder setMethodInfoName(SetPaymentMethodInfoName setMethodInfoName) {
      this.setMethodInfoName = setMethodInfoName;
      return this;
    }

    public Builder setStatusInterfaceCode(SetPaymentStatusInterfaceCode setStatusInterfaceCode) {
      this.setStatusInterfaceCode = setStatusInterfaceCode;
      return this;
    }

    public Builder setStatusInterfaceText(SetPaymentStatusInterfaceText setStatusInterfaceText) {
      this.setStatusInterfaceText = setStatusInterfaceText;
      return this;
    }

    public Builder setTransactionCustomField(
        SetPaymentTransactionCustomField setTransactionCustomField) {
      this.setTransactionCustomField = setTransactionCustomField;
      return this;
    }

    public Builder setTransactionCustomType(
        SetPaymentTransactionCustomType setTransactionCustomType) {
      this.setTransactionCustomType = setTransactionCustomType;
      return this;
    }

    public Builder transitionState(TransitionPaymentState transitionState) {
      this.transitionState = transitionState;
      return this;
    }
  }
}
