package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.Objects;

public class PriceSelectorInput {
  private Currency currency;

  private String country;

  private ReferenceInput customerGroup;

  private ReferenceInput channel;

  private OffsetDateTime date;

  public PriceSelectorInput() {
  }

  public PriceSelectorInput(Currency currency, String country, ReferenceInput customerGroup,
      ReferenceInput channel, OffsetDateTime date) {
    this.currency = currency;
    this.country = country;
    this.customerGroup = customerGroup;
    this.channel = channel;
    this.date = date;
  }

  public Currency getCurrency() {
    return currency;
  }

  public void setCurrency(Currency currency) {
    this.currency = currency;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public ReferenceInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ReferenceInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ReferenceInput getChannel() {
    return channel;
  }

  public void setChannel(ReferenceInput channel) {
    this.channel = channel;
  }

  public OffsetDateTime getDate() {
    return date;
  }

  public void setDate(OffsetDateTime date) {
    this.date = date;
  }

  @Override
  public String toString() {
    return "PriceSelectorInput{currency='" + currency + "', country='" + country + "', customerGroup='" + customerGroup + "', channel='" + channel + "', date='" + date + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PriceSelectorInput that = (PriceSelectorInput) o;
    return Objects.equals(currency, that.currency) &&
        Objects.equals(country, that.country) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(date, that.date);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, country, customerGroup, channel, date);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Currency currency;

    private String country;

    private ReferenceInput customerGroup;

    private ReferenceInput channel;

    private OffsetDateTime date;

    public PriceSelectorInput build() {
      PriceSelectorInput result = new PriceSelectorInput();
      result.currency = this.currency;
      result.country = this.country;
      result.customerGroup = this.customerGroup;
      result.channel = this.channel;
      result.date = this.date;
      return result;
    }

    public Builder currency(Currency currency) {
      this.currency = currency;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder customerGroup(ReferenceInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder channel(ReferenceInput channel) {
      this.channel = channel;
      return this;
    }

    public Builder date(OffsetDateTime date) {
      this.date = date;
      return this;
    }
  }
}
