package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Product implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReviewTarget, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private String key;

  private Long version;

  private Reference productTypeRef;

  private ProductTypeDefinition productType;

  private ProductCatalogData masterData;

  private List<String> skus;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Reference stateRef;

  private State state;

  private PriceMode priceMode;

  private Reference taxCategoryRef;

  private TaxCategory taxCategory;

  private ReviewRatingStatistics reviewRatingStatistics;

  private SelectionOfProductQueryResult productSelectionRefs;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Product() {
  }

  public Product(String id, String key, Long version, Reference productTypeRef,
      ProductTypeDefinition productType, ProductCatalogData masterData, List<String> skus,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Reference stateRef, State state,
      PriceMode priceMode, Reference taxCategoryRef, TaxCategory taxCategory,
      ReviewRatingStatistics reviewRatingStatistics,
      SelectionOfProductQueryResult productSelectionRefs, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.id = id;
    this.key = key;
    this.version = version;
    this.productTypeRef = productTypeRef;
    this.productType = productType;
    this.masterData = masterData;
    this.skus = skus;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.stateRef = stateRef;
    this.state = state;
    this.priceMode = priceMode;
    this.taxCategoryRef = taxCategoryRef;
    this.taxCategory = taxCategory;
    this.reviewRatingStatistics = reviewRatingStatistics;
    this.productSelectionRefs = productSelectionRefs;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public Reference getProductTypeRef() {
    return productTypeRef;
  }

  public void setProductTypeRef(Reference productTypeRef) {
    this.productTypeRef = productTypeRef;
  }

  public ProductTypeDefinition getProductType() {
    return productType;
  }

  public void setProductType(ProductTypeDefinition productType) {
    this.productType = productType;
  }

  public ProductCatalogData getMasterData() {
    return masterData;
  }

  public void setMasterData(ProductCatalogData masterData) {
    this.masterData = masterData;
  }

  public List<String> getSkus() {
    return skus;
  }

  public void setSkus(List<String> skus) {
    this.skus = skus;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public PriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(PriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public Reference getTaxCategoryRef() {
    return taxCategoryRef;
  }

  public void setTaxCategoryRef(Reference taxCategoryRef) {
    this.taxCategoryRef = taxCategoryRef;
  }

  public TaxCategory getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(TaxCategory taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ReviewRatingStatistics getReviewRatingStatistics() {
    return reviewRatingStatistics;
  }

  public void setReviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
    this.reviewRatingStatistics = reviewRatingStatistics;
  }

  public SelectionOfProductQueryResult getProductSelectionRefs() {
    return productSelectionRefs;
  }

  public void setProductSelectionRefs(SelectionOfProductQueryResult productSelectionRefs) {
    this.productSelectionRefs = productSelectionRefs;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Product{id='" + id + "', key='" + key + "', version='" + version + "', productTypeRef='" + productTypeRef + "', productType='" + productType + "', masterData='" + masterData + "', skus='" + skus + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', stateRef='" + stateRef + "', state='" + state + "', priceMode='" + priceMode + "', taxCategoryRef='" + taxCategoryRef + "', taxCategory='" + taxCategory + "', reviewRatingStatistics='" + reviewRatingStatistics + "', productSelectionRefs='" + productSelectionRefs + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Product that = (Product) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(version, that.version) &&
        Objects.equals(productTypeRef, that.productTypeRef) &&
        Objects.equals(productType, that.productType) &&
        Objects.equals(masterData, that.masterData) &&
        Objects.equals(skus, that.skus) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(priceMode, that.priceMode) &&
        Objects.equals(taxCategoryRef, that.taxCategoryRef) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(reviewRatingStatistics, that.reviewRatingStatistics) &&
        Objects.equals(productSelectionRefs, that.productSelectionRefs) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, version, productTypeRef, productType, masterData, skus, createdAt, lastModifiedAt, stateRef, state, priceMode, taxCategoryRef, taxCategory, reviewRatingStatistics, productSelectionRefs, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private Long version;

    private Reference productTypeRef;

    private ProductTypeDefinition productType;

    private ProductCatalogData masterData;

    private List<String> skus;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Reference stateRef;

    private State state;

    private PriceMode priceMode;

    private Reference taxCategoryRef;

    private TaxCategory taxCategory;

    private ReviewRatingStatistics reviewRatingStatistics;

    private SelectionOfProductQueryResult productSelectionRefs;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Product build() {
      Product result = new Product();
      result.id = this.id;
      result.key = this.key;
      result.version = this.version;
      result.productTypeRef = this.productTypeRef;
      result.productType = this.productType;
      result.masterData = this.masterData;
      result.skus = this.skus;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.priceMode = this.priceMode;
      result.taxCategoryRef = this.taxCategoryRef;
      result.taxCategory = this.taxCategory;
      result.reviewRatingStatistics = this.reviewRatingStatistics;
      result.productSelectionRefs = this.productSelectionRefs;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder productTypeRef(Reference productTypeRef) {
      this.productTypeRef = productTypeRef;
      return this;
    }

    public Builder productType(ProductTypeDefinition productType) {
      this.productType = productType;
      return this;
    }

    public Builder masterData(ProductCatalogData masterData) {
      this.masterData = masterData;
      return this;
    }

    public Builder skus(List<String> skus) {
      this.skus = skus;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder priceMode(PriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }

    public Builder taxCategoryRef(Reference taxCategoryRef) {
      this.taxCategoryRef = taxCategoryRef;
      return this;
    }

    public Builder taxCategory(TaxCategory taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder reviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
      this.reviewRatingStatistics = reviewRatingStatistics;
      return this;
    }

    public Builder productSelectionRefs(SelectionOfProductQueryResult productSelectionRefs) {
      this.productSelectionRefs = productSelectionRefs;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
