package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * An input object used to define a ProductAttribute.
 *
 * The value should be passed in a form of escaped JSON.
 *
 *
 * Examples for `value`:
 *
 * * FieldType `String`: `"\"This is a string\""`
 * * FieldType `DateTimeType`: `"\"2018-10-12T14:00:00.000Z\""`
 * * FieldType `Number`: `"4"`
 * * FieldType `Set` with an elementType of `String`: `"[\"This is a string\", \"This is another string\"]"`
 * * FieldType `Reference`: `"{\"id\": \"b911b62d-353a-4388-93ee-8d488d9af962\", \"typeId\": \"product\"}"`
 */
public class ProductAttributeInput {
  private String name;

  /**
   * The value should be passed in a form of escaped JSON.
   *
   *
   * Examples for `value`:
   *
   * * FieldType `String`: `"\"This is a string\""`
   * * FieldType `DateTimeType`: `"\"2018-10-12T14:00:00.000Z\""`
   * * FieldType `Number`: `"4"`
   * * FieldType `Set` with an elementType of `String`: `"[\"This is a string\", \"This is another string\"]"`
   * * FieldType `Reference`: `"{\"id\": \"b911b62d-353a-4388-93ee-8d488d9af962\", \"typeId\": \"product\"}"`
   */
  private String value;

  public ProductAttributeInput() {
  }

  public ProductAttributeInput(String name, String value) {
    this.name = name;
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  /**
   * The value should be passed in a form of escaped JSON.
   *
   *
   * Examples for `value`:
   *
   * * FieldType `String`: `"\"This is a string\""`
   * * FieldType `DateTimeType`: `"\"2018-10-12T14:00:00.000Z\""`
   * * FieldType `Number`: `"4"`
   * * FieldType `Set` with an elementType of `String`: `"[\"This is a string\", \"This is another string\"]"`
   * * FieldType `Reference`: `"{\"id\": \"b911b62d-353a-4388-93ee-8d488d9af962\", \"typeId\": \"product\"}"`
   */
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "ProductAttributeInput{name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductAttributeInput that = (ProductAttributeInput) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    /**
     * The value should be passed in a form of escaped JSON.
     *
     *
     * Examples for `value`:
     *
     * * FieldType `String`: `"\"This is a string\""`
     * * FieldType `DateTimeType`: `"\"2018-10-12T14:00:00.000Z\""`
     * * FieldType `Number`: `"4"`
     * * FieldType `Set` with an elementType of `String`: `"[\"This is a string\", \"This is another string\"]"`
     * * FieldType `Reference`: `"{\"id\": \"b911b62d-353a-4388-93ee-8d488d9af962\", \"typeId\": \"product\"}"`
     */
    private String value;

    public ProductAttributeInput build() {
      ProductAttributeInput result = new ProductAttributeInput();
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * The value should be passed in a form of escaped JSON.
     *
     *
     * Examples for `value`:
     *
     * * FieldType `String`: `"\"This is a string\""`
     * * FieldType `DateTimeType`: `"\"2018-10-12T14:00:00.000Z\""`
     * * FieldType `Number`: `"4"`
     * * FieldType `Set` with an elementType of `String`: `"[\"This is a string\", \"This is another string\"]"`
     * * FieldType `Reference`: `"{\"id\": \"b911b62d-353a-4388-93ee-8d488d9af962\", \"typeId\": \"product\"}"`
     */
    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
