package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductData {
  private String name;

  private String description;

  private List<LocalizedString> nameAllLocales;

  private List<LocalizedString> descriptionAllLocales;

  private String slug;

  private List<LocalizedString> slugAllLocales;

  private String categoryOrderHint;

  private List<CategoryOrderHint> categoryOrderHints;

  private List<Reference> categoriesRef;

  private List<Category> categories;

  private List<SearchKeyword> searchKeyword;

  private List<SearchKeywords> searchKeywords;

  private String metaTitle;

  private List<LocalizedString> metaTitleAllLocales;

  private String metaKeywords;

  private List<LocalizedString> metaKeywordsAllLocales;

  private String metaDescription;

  private List<LocalizedString> metaDescriptionAllLocales;

  private ProductVariant masterVariant;

  private List<ProductVariant> variants;

  /**
   * Fetch all variants, including the master variant in first position.
   */
  private List<ProductVariant> allVariants;

  private ProductVariant variant;

  private List<String> skus;

  public ProductData() {
  }

  public ProductData(String name, String description, List<LocalizedString> nameAllLocales,
      List<LocalizedString> descriptionAllLocales, String slug,
      List<LocalizedString> slugAllLocales, String categoryOrderHint,
      List<CategoryOrderHint> categoryOrderHints, List<Reference> categoriesRef,
      List<Category> categories, List<SearchKeyword> searchKeyword,
      List<SearchKeywords> searchKeywords, String metaTitle,
      List<LocalizedString> metaTitleAllLocales, String metaKeywords,
      List<LocalizedString> metaKeywordsAllLocales, String metaDescription,
      List<LocalizedString> metaDescriptionAllLocales, ProductVariant masterVariant,
      List<ProductVariant> variants, List<ProductVariant> allVariants, ProductVariant variant,
      List<String> skus) {
    this.name = name;
    this.description = description;
    this.nameAllLocales = nameAllLocales;
    this.descriptionAllLocales = descriptionAllLocales;
    this.slug = slug;
    this.slugAllLocales = slugAllLocales;
    this.categoryOrderHint = categoryOrderHint;
    this.categoryOrderHints = categoryOrderHints;
    this.categoriesRef = categoriesRef;
    this.categories = categories;
    this.searchKeyword = searchKeyword;
    this.searchKeywords = searchKeywords;
    this.metaTitle = metaTitle;
    this.metaTitleAllLocales = metaTitleAllLocales;
    this.metaKeywords = metaKeywords;
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
    this.metaDescription = metaDescription;
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
    this.masterVariant = masterVariant;
    this.variants = variants;
    this.allVariants = allVariants;
    this.variant = variant;
    this.skus = skus;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public String getCategoryOrderHint() {
    return categoryOrderHint;
  }

  public void setCategoryOrderHint(String categoryOrderHint) {
    this.categoryOrderHint = categoryOrderHint;
  }

  public List<CategoryOrderHint> getCategoryOrderHints() {
    return categoryOrderHints;
  }

  public void setCategoryOrderHints(List<CategoryOrderHint> categoryOrderHints) {
    this.categoryOrderHints = categoryOrderHints;
  }

  public List<Reference> getCategoriesRef() {
    return categoriesRef;
  }

  public void setCategoriesRef(List<Reference> categoriesRef) {
    this.categoriesRef = categoriesRef;
  }

  public List<Category> getCategories() {
    return categories;
  }

  public void setCategories(List<Category> categories) {
    this.categories = categories;
  }

  public List<SearchKeyword> getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(List<SearchKeyword> searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  public List<SearchKeywords> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SearchKeywords> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  public String getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(String metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedString> getMetaTitleAllLocales() {
    return metaTitleAllLocales;
  }

  public void setMetaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
    this.metaTitleAllLocales = metaTitleAllLocales;
  }

  public String getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(String metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedString> getMetaKeywordsAllLocales() {
    return metaKeywordsAllLocales;
  }

  public void setMetaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
  }

  public String getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(String metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedString> getMetaDescriptionAllLocales() {
    return metaDescriptionAllLocales;
  }

  public void setMetaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
  }

  public ProductVariant getMasterVariant() {
    return masterVariant;
  }

  public void setMasterVariant(ProductVariant masterVariant) {
    this.masterVariant = masterVariant;
  }

  public List<ProductVariant> getVariants() {
    return variants;
  }

  public void setVariants(List<ProductVariant> variants) {
    this.variants = variants;
  }

  /**
   * Fetch all variants, including the master variant in first position.
   */
  public List<ProductVariant> getAllVariants() {
    return allVariants;
  }

  public void setAllVariants(List<ProductVariant> allVariants) {
    this.allVariants = allVariants;
  }

  public ProductVariant getVariant() {
    return variant;
  }

  public void setVariant(ProductVariant variant) {
    this.variant = variant;
  }

  public List<String> getSkus() {
    return skus;
  }

  public void setSkus(List<String> skus) {
    this.skus = skus;
  }

  @Override
  public String toString() {
    return "ProductData{name='" + name + "', description='" + description + "', nameAllLocales='" + nameAllLocales + "', descriptionAllLocales='" + descriptionAllLocales + "', slug='" + slug + "', slugAllLocales='" + slugAllLocales + "', categoryOrderHint='" + categoryOrderHint + "', categoryOrderHints='" + categoryOrderHints + "', categoriesRef='" + categoriesRef + "', categories='" + categories + "', searchKeyword='" + searchKeyword + "', searchKeywords='" + searchKeywords + "', metaTitle='" + metaTitle + "', metaTitleAllLocales='" + metaTitleAllLocales + "', metaKeywords='" + metaKeywords + "', metaKeywordsAllLocales='" + metaKeywordsAllLocales + "', metaDescription='" + metaDescription + "', metaDescriptionAllLocales='" + metaDescriptionAllLocales + "', masterVariant='" + masterVariant + "', variants='" + variants + "', allVariants='" + allVariants + "', variant='" + variant + "', skus='" + skus + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductData that = (ProductData) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(categoryOrderHint, that.categoryOrderHint) &&
        Objects.equals(categoryOrderHints, that.categoryOrderHints) &&
        Objects.equals(categoriesRef, that.categoriesRef) &&
        Objects.equals(categories, that.categories) &&
        Objects.equals(searchKeyword, that.searchKeyword) &&
        Objects.equals(searchKeywords, that.searchKeywords) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaTitleAllLocales, that.metaTitleAllLocales) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(metaKeywordsAllLocales, that.metaKeywordsAllLocales) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaDescriptionAllLocales, that.metaDescriptionAllLocales) &&
        Objects.equals(masterVariant, that.masterVariant) &&
        Objects.equals(variants, that.variants) &&
        Objects.equals(allVariants, that.allVariants) &&
        Objects.equals(variant, that.variant) &&
        Objects.equals(skus, that.skus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, nameAllLocales, descriptionAllLocales, slug, slugAllLocales, categoryOrderHint, categoryOrderHints, categoriesRef, categories, searchKeyword, searchKeywords, metaTitle, metaTitleAllLocales, metaKeywords, metaKeywordsAllLocales, metaDescription, metaDescriptionAllLocales, masterVariant, variants, allVariants, variant, skus);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String description;

    private List<LocalizedString> nameAllLocales;

    private List<LocalizedString> descriptionAllLocales;

    private String slug;

    private List<LocalizedString> slugAllLocales;

    private String categoryOrderHint;

    private List<CategoryOrderHint> categoryOrderHints;

    private List<Reference> categoriesRef;

    private List<Category> categories;

    private List<SearchKeyword> searchKeyword;

    private List<SearchKeywords> searchKeywords;

    private String metaTitle;

    private List<LocalizedString> metaTitleAllLocales;

    private String metaKeywords;

    private List<LocalizedString> metaKeywordsAllLocales;

    private String metaDescription;

    private List<LocalizedString> metaDescriptionAllLocales;

    private ProductVariant masterVariant;

    private List<ProductVariant> variants;

    /**
     * Fetch all variants, including the master variant in first position.
     */
    private List<ProductVariant> allVariants;

    private ProductVariant variant;

    private List<String> skus;

    public ProductData build() {
      ProductData result = new ProductData();
      result.name = this.name;
      result.description = this.description;
      result.nameAllLocales = this.nameAllLocales;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.slug = this.slug;
      result.slugAllLocales = this.slugAllLocales;
      result.categoryOrderHint = this.categoryOrderHint;
      result.categoryOrderHints = this.categoryOrderHints;
      result.categoriesRef = this.categoriesRef;
      result.categories = this.categories;
      result.searchKeyword = this.searchKeyword;
      result.searchKeywords = this.searchKeywords;
      result.metaTitle = this.metaTitle;
      result.metaTitleAllLocales = this.metaTitleAllLocales;
      result.metaKeywords = this.metaKeywords;
      result.metaKeywordsAllLocales = this.metaKeywordsAllLocales;
      result.metaDescription = this.metaDescription;
      result.metaDescriptionAllLocales = this.metaDescriptionAllLocales;
      result.masterVariant = this.masterVariant;
      result.variants = this.variants;
      result.allVariants = this.allVariants;
      result.variant = this.variant;
      result.skus = this.skus;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder categoryOrderHint(String categoryOrderHint) {
      this.categoryOrderHint = categoryOrderHint;
      return this;
    }

    public Builder categoryOrderHints(List<CategoryOrderHint> categoryOrderHints) {
      this.categoryOrderHints = categoryOrderHints;
      return this;
    }

    public Builder categoriesRef(List<Reference> categoriesRef) {
      this.categoriesRef = categoriesRef;
      return this;
    }

    public Builder categories(List<Category> categories) {
      this.categories = categories;
      return this;
    }

    public Builder searchKeyword(List<SearchKeyword> searchKeyword) {
      this.searchKeyword = searchKeyword;
      return this;
    }

    public Builder searchKeywords(List<SearchKeywords> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }

    public Builder metaTitle(String metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
      this.metaTitleAllLocales = metaTitleAllLocales;
      return this;
    }

    public Builder metaKeywords(String metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder metaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
      this.metaKeywordsAllLocales = metaKeywordsAllLocales;
      return this;
    }

    public Builder metaDescription(String metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
      this.metaDescriptionAllLocales = metaDescriptionAllLocales;
      return this;
    }

    public Builder masterVariant(ProductVariant masterVariant) {
      this.masterVariant = masterVariant;
      return this;
    }

    public Builder variants(List<ProductVariant> variants) {
      this.variants = variants;
      return this;
    }

    /**
     * Fetch all variants, including the master variant in first position.
     */
    public Builder allVariants(List<ProductVariant> allVariants) {
      this.allVariants = allVariants;
      return this;
    }

    public Builder variant(ProductVariant variant) {
      this.variant = variant;
      return this;
    }

    public Builder skus(List<String> skus) {
      this.skus = skus;
      return this;
    }
  }
}
