package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductDeleted implements com.commercetools.graphql.api.types.MessagePayload {
  private Object removedImageUrls;

  private ProductProjectionMessagePayload currentProjection;

  private String type;

  public ProductDeleted() {
  }

  public ProductDeleted(Object removedImageUrls, ProductProjectionMessagePayload currentProjection,
      String type) {
    this.removedImageUrls = removedImageUrls;
    this.currentProjection = currentProjection;
    this.type = type;
  }

  public Object getRemovedImageUrls() {
    return removedImageUrls;
  }

  public void setRemovedImageUrls(Object removedImageUrls) {
    this.removedImageUrls = removedImageUrls;
  }

  public ProductProjectionMessagePayload getCurrentProjection() {
    return currentProjection;
  }

  public void setCurrentProjection(ProductProjectionMessagePayload currentProjection) {
    this.currentProjection = currentProjection;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductDeleted{removedImageUrls='" + removedImageUrls + "', currentProjection='" + currentProjection + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDeleted that = (ProductDeleted) o;
    return Objects.equals(removedImageUrls, that.removedImageUrls) &&
        Objects.equals(currentProjection, that.currentProjection) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(removedImageUrls, currentProjection, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Object removedImageUrls;

    private ProductProjectionMessagePayload currentProjection;

    private String type;

    public ProductDeleted build() {
      ProductDeleted result = new ProductDeleted();
      result.removedImageUrls = this.removedImageUrls;
      result.currentProjection = this.currentProjection;
      result.type = this.type;
      return result;
    }

    public Builder removedImageUrls(Object removedImageUrls) {
      this.removedImageUrls = removedImageUrls;
      return this;
    }

    public Builder currentProjection(ProductProjectionMessagePayload currentProjection) {
      this.currentProjection = currentProjection;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
