package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 *
 * A product price can be discounted in two ways:
 *
 * * with a relative or an absolute product discount, which will be automatically applied to all prices in a product that match a discount predicate.
 *   A relative discount reduces the matching price by a fraction (for example 10 % off). An absolute discount reduces the matching price by a fixed amount (for example 10€ off). If more than one product discount matches a price, the discount sort order determines which one will be applied.
 * * with an external product discount, which can then be used to explicitly set a discounted value on a particular product price.
 *
 * The discounted price is stored in the discounted field of the Product Price.
 *
 * Note that when a discount is created, updated or removed it can take up to 15 minutes to update all the prices with the discounts.
 *
 * The maximum number of ProductDiscounts that can be active at the same time is **200**.
 *       
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductDiscount implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String predicate;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private Boolean isActive;

  private Boolean isValid;

  private String sortOrder;

  private String key;

  private String name;

  private String description;

  private List<Reference> referenceRefs;

  private List<LocalizedString> nameAllLocales;

  private List<LocalizedString> descriptionAllLocales;

  private ProductDiscountValue value;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ProductDiscount() {
  }

  public ProductDiscount(String predicate, OffsetDateTime validFrom, OffsetDateTime validUntil,
      Boolean isActive, Boolean isValid, String sortOrder, String key, String name,
      String description, List<Reference> referenceRefs, List<LocalizedString> nameAllLocales,
      List<LocalizedString> descriptionAllLocales, ProductDiscountValue value, String id,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.predicate = predicate;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.isActive = isActive;
    this.isValid = isValid;
    this.sortOrder = sortOrder;
    this.key = key;
    this.name = name;
    this.description = description;
    this.referenceRefs = referenceRefs;
    this.nameAllLocales = nameAllLocales;
    this.descriptionAllLocales = descriptionAllLocales;
    this.value = value;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public Boolean getIsValid() {
    return isValid;
  }

  public void setIsValid(Boolean isValid) {
    this.isValid = isValid;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<Reference> getReferenceRefs() {
    return referenceRefs;
  }

  public void setReferenceRefs(List<Reference> referenceRefs) {
    this.referenceRefs = referenceRefs;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public ProductDiscountValue getValue() {
    return value;
  }

  public void setValue(ProductDiscountValue value) {
    this.value = value;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ProductDiscount{predicate='" + predicate + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', isActive='" + isActive + "', isValid='" + isValid + "', sortOrder='" + sortOrder + "', key='" + key + "', name='" + name + "', description='" + description + "', referenceRefs='" + referenceRefs + "', nameAllLocales='" + nameAllLocales + "', descriptionAllLocales='" + descriptionAllLocales + "', value='" + value + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDiscount that = (ProductDiscount) o;
    return Objects.equals(predicate, that.predicate) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(isValid, that.isValid) &&
        Objects.equals(sortOrder, that.sortOrder) &&
        Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(referenceRefs, that.referenceRefs) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(value, that.value) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate, validFrom, validUntil, isActive, isValid, sortOrder, key, name, description, referenceRefs, nameAllLocales, descriptionAllLocales, value, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private Boolean isActive;

    private Boolean isValid;

    private String sortOrder;

    private String key;

    private String name;

    private String description;

    private List<Reference> referenceRefs;

    private List<LocalizedString> nameAllLocales;

    private List<LocalizedString> descriptionAllLocales;

    private ProductDiscountValue value;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ProductDiscount build() {
      ProductDiscount result = new ProductDiscount();
      result.predicate = this.predicate;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.isActive = this.isActive;
      result.isValid = this.isValid;
      result.sortOrder = this.sortOrder;
      result.key = this.key;
      result.name = this.name;
      result.description = this.description;
      result.referenceRefs = this.referenceRefs;
      result.nameAllLocales = this.nameAllLocales;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.value = this.value;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder isValid(Boolean isValid) {
      this.isValid = isValid;
      return this;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder referenceRefs(List<Reference> referenceRefs) {
      this.referenceRefs = referenceRefs;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder value(ProductDiscountValue value) {
      this.value = value;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
