package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductDiscountLimitsProjection {
  private ProductDiscountLimitWithCurrent totalActive;

  public ProductDiscountLimitsProjection() {
  }

  public ProductDiscountLimitsProjection(ProductDiscountLimitWithCurrent totalActive) {
    this.totalActive = totalActive;
  }

  public ProductDiscountLimitWithCurrent getTotalActive() {
    return totalActive;
  }

  public void setTotalActive(ProductDiscountLimitWithCurrent totalActive) {
    this.totalActive = totalActive;
  }

  @Override
  public String toString() {
    return "ProductDiscountLimitsProjection{totalActive='" + totalActive + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDiscountLimitsProjection that = (ProductDiscountLimitsProjection) o;
    return Objects.equals(totalActive, that.totalActive);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalActive);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductDiscountLimitWithCurrent totalActive;

    public ProductDiscountLimitsProjection build() {
      ProductDiscountLimitsProjection result = new ProductDiscountLimitsProjection();
      result.totalActive = this.totalActive;
      return result;
    }

    public Builder totalActive(ProductDiscountLimitWithCurrent totalActive) {
      this.totalActive = totalActive;
      return this;
    }
  }
}
