package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductDiscountUpdateAction {
  private ChangeProductDiscountIsActive changeIsActive;

  private ChangeProductDiscountName changeName;

  private ChangeProductDiscountPredicate changePredicate;

  private ChangeProductDiscountSortOrder changeSortOrder;

  private ChangeProductDiscountValue changeValue;

  private SetProductDiscountDescription setDescription;

  private SetProductDiscountKey setKey;

  private SetProductDiscountValidFrom setValidFrom;

  private SetProductDiscountValidFromAndUntil setValidFromAndUntil;

  private SetProductDiscountValidUntil setValidUntil;

  public ProductDiscountUpdateAction() {
  }

  public ProductDiscountUpdateAction(ChangeProductDiscountIsActive changeIsActive,
      ChangeProductDiscountName changeName, ChangeProductDiscountPredicate changePredicate,
      ChangeProductDiscountSortOrder changeSortOrder, ChangeProductDiscountValue changeValue,
      SetProductDiscountDescription setDescription, SetProductDiscountKey setKey,
      SetProductDiscountValidFrom setValidFrom,
      SetProductDiscountValidFromAndUntil setValidFromAndUntil,
      SetProductDiscountValidUntil setValidUntil) {
    this.changeIsActive = changeIsActive;
    this.changeName = changeName;
    this.changePredicate = changePredicate;
    this.changeSortOrder = changeSortOrder;
    this.changeValue = changeValue;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setValidFrom = setValidFrom;
    this.setValidFromAndUntil = setValidFromAndUntil;
    this.setValidUntil = setValidUntil;
  }

  public ChangeProductDiscountIsActive getChangeIsActive() {
    return changeIsActive;
  }

  public void setChangeIsActive(ChangeProductDiscountIsActive changeIsActive) {
    this.changeIsActive = changeIsActive;
  }

  public ChangeProductDiscountName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeProductDiscountName changeName) {
    this.changeName = changeName;
  }

  public ChangeProductDiscountPredicate getChangePredicate() {
    return changePredicate;
  }

  public void setChangePredicate(ChangeProductDiscountPredicate changePredicate) {
    this.changePredicate = changePredicate;
  }

  public ChangeProductDiscountSortOrder getChangeSortOrder() {
    return changeSortOrder;
  }

  public void setChangeSortOrder(ChangeProductDiscountSortOrder changeSortOrder) {
    this.changeSortOrder = changeSortOrder;
  }

  public ChangeProductDiscountValue getChangeValue() {
    return changeValue;
  }

  public void setChangeValue(ChangeProductDiscountValue changeValue) {
    this.changeValue = changeValue;
  }

  public SetProductDiscountDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetProductDiscountDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetProductDiscountKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetProductDiscountKey setKey) {
    this.setKey = setKey;
  }

  public SetProductDiscountValidFrom getSetValidFrom() {
    return setValidFrom;
  }

  public void setSetValidFrom(SetProductDiscountValidFrom setValidFrom) {
    this.setValidFrom = setValidFrom;
  }

  public SetProductDiscountValidFromAndUntil getSetValidFromAndUntil() {
    return setValidFromAndUntil;
  }

  public void setSetValidFromAndUntil(SetProductDiscountValidFromAndUntil setValidFromAndUntil) {
    this.setValidFromAndUntil = setValidFromAndUntil;
  }

  public SetProductDiscountValidUntil getSetValidUntil() {
    return setValidUntil;
  }

  public void setSetValidUntil(SetProductDiscountValidUntil setValidUntil) {
    this.setValidUntil = setValidUntil;
  }

  @Override
  public String toString() {
    return "ProductDiscountUpdateAction{changeIsActive='" + changeIsActive + "', changeName='" + changeName + "', changePredicate='" + changePredicate + "', changeSortOrder='" + changeSortOrder + "', changeValue='" + changeValue + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setValidFrom='" + setValidFrom + "', setValidFromAndUntil='" + setValidFromAndUntil + "', setValidUntil='" + setValidUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDiscountUpdateAction that = (ProductDiscountUpdateAction) o;
    return Objects.equals(changeIsActive, that.changeIsActive) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changePredicate, that.changePredicate) &&
        Objects.equals(changeSortOrder, that.changeSortOrder) &&
        Objects.equals(changeValue, that.changeValue) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setValidFrom, that.setValidFrom) &&
        Objects.equals(setValidFromAndUntil, that.setValidFromAndUntil) &&
        Objects.equals(setValidUntil, that.setValidUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeIsActive, changeName, changePredicate, changeSortOrder, changeValue, setDescription, setKey, setValidFrom, setValidFromAndUntil, setValidUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeProductDiscountIsActive changeIsActive;

    private ChangeProductDiscountName changeName;

    private ChangeProductDiscountPredicate changePredicate;

    private ChangeProductDiscountSortOrder changeSortOrder;

    private ChangeProductDiscountValue changeValue;

    private SetProductDiscountDescription setDescription;

    private SetProductDiscountKey setKey;

    private SetProductDiscountValidFrom setValidFrom;

    private SetProductDiscountValidFromAndUntil setValidFromAndUntil;

    private SetProductDiscountValidUntil setValidUntil;

    public ProductDiscountUpdateAction build() {
      ProductDiscountUpdateAction result = new ProductDiscountUpdateAction();
      result.changeIsActive = this.changeIsActive;
      result.changeName = this.changeName;
      result.changePredicate = this.changePredicate;
      result.changeSortOrder = this.changeSortOrder;
      result.changeValue = this.changeValue;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setValidFrom = this.setValidFrom;
      result.setValidFromAndUntil = this.setValidFromAndUntil;
      result.setValidUntil = this.setValidUntil;
      return result;
    }

    public Builder changeIsActive(ChangeProductDiscountIsActive changeIsActive) {
      this.changeIsActive = changeIsActive;
      return this;
    }

    public Builder changeName(ChangeProductDiscountName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changePredicate(ChangeProductDiscountPredicate changePredicate) {
      this.changePredicate = changePredicate;
      return this;
    }

    public Builder changeSortOrder(ChangeProductDiscountSortOrder changeSortOrder) {
      this.changeSortOrder = changeSortOrder;
      return this;
    }

    public Builder changeValue(ChangeProductDiscountValue changeValue) {
      this.changeValue = changeValue;
      return this;
    }

    public Builder setDescription(SetProductDiscountDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetProductDiscountKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setValidFrom(SetProductDiscountValidFrom setValidFrom) {
      this.setValidFrom = setValidFrom;
      return this;
    }

    public Builder setValidFromAndUntil(SetProductDiscountValidFromAndUntil setValidFromAndUntil) {
      this.setValidFromAndUntil = setValidFromAndUntil;
      return this;
    }

    public Builder setValidUntil(SetProductDiscountValidUntil setValidUntil) {
      this.setValidUntil = setValidUntil;
      return this;
    }
  }
}
