package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductDiscountValueInput {
  private RelativeDiscountValueInput relative;

  private AbsoluteDiscountValueInput absolute;

  private ExternalDiscountValueInput external;

  public ProductDiscountValueInput() {
  }

  public ProductDiscountValueInput(RelativeDiscountValueInput relative,
      AbsoluteDiscountValueInput absolute, ExternalDiscountValueInput external) {
    this.relative = relative;
    this.absolute = absolute;
    this.external = external;
  }

  public RelativeDiscountValueInput getRelative() {
    return relative;
  }

  public void setRelative(RelativeDiscountValueInput relative) {
    this.relative = relative;
  }

  public AbsoluteDiscountValueInput getAbsolute() {
    return absolute;
  }

  public void setAbsolute(AbsoluteDiscountValueInput absolute) {
    this.absolute = absolute;
  }

  public ExternalDiscountValueInput getExternal() {
    return external;
  }

  public void setExternal(ExternalDiscountValueInput external) {
    this.external = external;
  }

  @Override
  public String toString() {
    return "ProductDiscountValueInput{relative='" + relative + "', absolute='" + absolute + "', external='" + external + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDiscountValueInput that = (ProductDiscountValueInput) o;
    return Objects.equals(relative, that.relative) &&
        Objects.equals(absolute, that.absolute) &&
        Objects.equals(external, that.external);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relative, absolute, external);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private RelativeDiscountValueInput relative;

    private AbsoluteDiscountValueInput absolute;

    private ExternalDiscountValueInput external;

    public ProductDiscountValueInput build() {
      ProductDiscountValueInput result = new ProductDiscountValueInput();
      result.relative = this.relative;
      result.absolute = this.absolute;
      result.external = this.external;
      return result;
    }

    public Builder relative(RelativeDiscountValueInput relative) {
      this.relative = relative;
      return this;
    }

    public Builder absolute(AbsoluteDiscountValueInput absolute) {
      this.absolute = absolute;
      return this;
    }

    public Builder external(ExternalDiscountValueInput external) {
      this.external = external;
      return this;
    }
  }
}
