package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductLimitsProjection {
  private Limit pricesPerVariant;

  private Limit variants;

  private Limit productTailoring;

  public ProductLimitsProjection() {
  }

  public ProductLimitsProjection(Limit pricesPerVariant, Limit variants, Limit productTailoring) {
    this.pricesPerVariant = pricesPerVariant;
    this.variants = variants;
    this.productTailoring = productTailoring;
  }

  public Limit getPricesPerVariant() {
    return pricesPerVariant;
  }

  public void setPricesPerVariant(Limit pricesPerVariant) {
    this.pricesPerVariant = pricesPerVariant;
  }

  public Limit getVariants() {
    return variants;
  }

  public void setVariants(Limit variants) {
    this.variants = variants;
  }

  public Limit getProductTailoring() {
    return productTailoring;
  }

  public void setProductTailoring(Limit productTailoring) {
    this.productTailoring = productTailoring;
  }

  @Override
  public String toString() {
    return "ProductLimitsProjection{pricesPerVariant='" + pricesPerVariant + "', variants='" + variants + "', productTailoring='" + productTailoring + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductLimitsProjection that = (ProductLimitsProjection) o;
    return Objects.equals(pricesPerVariant, that.pricesPerVariant) &&
        Objects.equals(variants, that.variants) &&
        Objects.equals(productTailoring, that.productTailoring);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pricesPerVariant, variants, productTailoring);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit pricesPerVariant;

    private Limit variants;

    private Limit productTailoring;

    public ProductLimitsProjection build() {
      ProductLimitsProjection result = new ProductLimitsProjection();
      result.pricesPerVariant = this.pricesPerVariant;
      result.variants = this.variants;
      result.productTailoring = this.productTailoring;
      return result;
    }

    public Builder pricesPerVariant(Limit pricesPerVariant) {
      this.pricesPerVariant = pricesPerVariant;
      return this;
    }

    public Builder variants(Limit variants) {
      this.variants = variants;
      return this;
    }

    public Builder productTailoring(Limit productTailoring) {
      this.productTailoring = productTailoring;
      return this;
    }
  }
}
