package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductOfSelection {
  private Reference productRef;

  private Product product;

  private ProductVariantSelection variantSelection;

  private ProductVariantExclusion variantExclusion;

  public ProductOfSelection() {
  }

  public ProductOfSelection(Reference productRef, Product product,
      ProductVariantSelection variantSelection, ProductVariantExclusion variantExclusion) {
    this.productRef = productRef;
    this.product = product;
    this.variantSelection = variantSelection;
    this.variantExclusion = variantExclusion;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public ProductVariantSelection getVariantSelection() {
    return variantSelection;
  }

  public void setVariantSelection(ProductVariantSelection variantSelection) {
    this.variantSelection = variantSelection;
  }

  public ProductVariantExclusion getVariantExclusion() {
    return variantExclusion;
  }

  public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
    this.variantExclusion = variantExclusion;
  }

  @Override
  public String toString() {
    return "ProductOfSelection{productRef='" + productRef + "', product='" + product + "', variantSelection='" + variantSelection + "', variantExclusion='" + variantExclusion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductOfSelection that = (ProductOfSelection) o;
    return Objects.equals(productRef, that.productRef) &&
        Objects.equals(product, that.product) &&
        Objects.equals(variantSelection, that.variantSelection) &&
        Objects.equals(variantExclusion, that.variantExclusion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productRef, product, variantSelection, variantExclusion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference productRef;

    private Product product;

    private ProductVariantSelection variantSelection;

    private ProductVariantExclusion variantExclusion;

    public ProductOfSelection build() {
      ProductOfSelection result = new ProductOfSelection();
      result.productRef = this.productRef;
      result.product = this.product;
      result.variantSelection = this.variantSelection;
      result.variantExclusion = this.variantExclusion;
      return result;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder variantSelection(ProductVariantSelection variantSelection) {
      this.variantSelection = variantSelection;
      return this;
    }

    public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
      this.variantExclusion = variantExclusion;
      return this;
    }
  }
}
