package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private ProductPrice price;

  private Boolean staged;

  private String type;

  public ProductPriceAdded() {
  }

  public ProductPriceAdded(Integer variantId, ProductPrice price, Boolean staged, String type) {
    this.variantId = variantId;
    this.price = price;
    this.staged = staged;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public ProductPrice getPrice() {
    return price;
  }

  public void setPrice(ProductPrice price) {
    this.price = price;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceAdded{variantId='" + variantId + "', price='" + price + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceAdded that = (ProductPriceAdded) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(price, that.price) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, price, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private ProductPrice price;

    private Boolean staged;

    private String type;

    public ProductPriceAdded build() {
      ProductPriceAdded result = new ProductPriceAdded();
      result.variantId = this.variantId;
      result.price = this.price;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder price(ProductPrice price) {
      this.price = price;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
