package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductPriceDataInput {
  private BaseMoneyInput value;

  private String key;

  private String country;

  private ReferenceInput customerGroup;

  private ResourceIdentifierInput channel;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private List<ProductPriceTierInput> tiers = Collections.emptyList();

  private CustomFieldsDraft custom;

  private DiscountedProductPriceValueInput discounted;

  public ProductPriceDataInput() {
  }

  public ProductPriceDataInput(BaseMoneyInput value, String key, String country,
      ReferenceInput customerGroup, ResourceIdentifierInput channel, OffsetDateTime validFrom,
      OffsetDateTime validUntil, List<ProductPriceTierInput> tiers, CustomFieldsDraft custom,
      DiscountedProductPriceValueInput discounted) {
    this.value = value;
    this.key = key;
    this.country = country;
    this.customerGroup = customerGroup;
    this.channel = channel;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.tiers = tiers;
    this.custom = custom;
    this.discounted = discounted;
  }

  public BaseMoneyInput getValue() {
    return value;
  }

  public void setValue(BaseMoneyInput value) {
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public ReferenceInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ReferenceInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ResourceIdentifierInput getChannel() {
    return channel;
  }

  public void setChannel(ResourceIdentifierInput channel) {
    this.channel = channel;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public List<ProductPriceTierInput> getTiers() {
    return tiers;
  }

  public void setTiers(List<ProductPriceTierInput> tiers) {
    this.tiers = tiers;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public DiscountedProductPriceValueInput getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValueInput discounted) {
    this.discounted = discounted;
  }

  @Override
  public String toString() {
    return "ProductPriceDataInput{value='" + value + "', key='" + key + "', country='" + country + "', customerGroup='" + customerGroup + "', channel='" + channel + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', tiers='" + tiers + "', custom='" + custom + "', discounted='" + discounted + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceDataInput that = (ProductPriceDataInput) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(key, that.key) &&
        Objects.equals(country, that.country) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(tiers, that.tiers) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(discounted, that.discounted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, key, country, customerGroup, channel, validFrom, validUntil, tiers, custom, discounted);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoneyInput value;

    private String key;

    private String country;

    private ReferenceInput customerGroup;

    private ResourceIdentifierInput channel;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private List<ProductPriceTierInput> tiers = Collections.emptyList();

    private CustomFieldsDraft custom;

    private DiscountedProductPriceValueInput discounted;

    public ProductPriceDataInput build() {
      ProductPriceDataInput result = new ProductPriceDataInput();
      result.value = this.value;
      result.key = this.key;
      result.country = this.country;
      result.customerGroup = this.customerGroup;
      result.channel = this.channel;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.tiers = this.tiers;
      result.custom = this.custom;
      result.discounted = this.discounted;
      return result;
    }

    public Builder value(BaseMoneyInput value) {
      this.value = value;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder customerGroup(ReferenceInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder channel(ResourceIdentifierInput channel) {
      this.channel = channel;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder tiers(List<ProductPriceTierInput> tiers) {
      this.tiers = tiers;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValueInput discounted) {
      this.discounted = discounted;
      return this;
    }
  }
}
