package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceDiscountsSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<ProductPriceDiscountUpdateMessagePayload> updatedPrices;

  private String type;

  public ProductPriceDiscountsSet() {
  }

  public ProductPriceDiscountsSet(List<ProductPriceDiscountUpdateMessagePayload> updatedPrices,
      String type) {
    this.updatedPrices = updatedPrices;
    this.type = type;
  }

  public List<ProductPriceDiscountUpdateMessagePayload> getUpdatedPrices() {
    return updatedPrices;
  }

  public void setUpdatedPrices(List<ProductPriceDiscountUpdateMessagePayload> updatedPrices) {
    this.updatedPrices = updatedPrices;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceDiscountsSet{updatedPrices='" + updatedPrices + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceDiscountsSet that = (ProductPriceDiscountsSet) o;
    return Objects.equals(updatedPrices, that.updatedPrices) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(updatedPrices, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ProductPriceDiscountUpdateMessagePayload> updatedPrices;

    private String type;

    public ProductPriceDiscountsSet build() {
      ProductPriceDiscountsSet result = new ProductPriceDiscountsSet();
      result.updatedPrices = this.updatedPrices;
      result.type = this.type;
      return result;
    }

    public Builder updatedPrices(List<ProductPriceDiscountUpdateMessagePayload> updatedPrices) {
      this.updatedPrices = updatedPrices;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
