package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceExternalDiscountSet implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private String variantKey;

  private String sku;

  private String priceId;

  private DiscountedProductPriceValue discounted;

  private Boolean staged;

  private String type;

  public ProductPriceExternalDiscountSet() {
  }

  public ProductPriceExternalDiscountSet(Integer variantId, String variantKey, String sku,
      String priceId, DiscountedProductPriceValue discounted, Boolean staged, String type) {
    this.variantId = variantId;
    this.variantKey = variantKey;
    this.sku = sku;
    this.priceId = priceId;
    this.discounted = discounted;
    this.staged = staged;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getVariantKey() {
    return variantKey;
  }

  public void setVariantKey(String variantKey) {
    this.variantKey = variantKey;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public DiscountedProductPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValue discounted) {
    this.discounted = discounted;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceExternalDiscountSet{variantId='" + variantId + "', variantKey='" + variantKey + "', sku='" + sku + "', priceId='" + priceId + "', discounted='" + discounted + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceExternalDiscountSet that = (ProductPriceExternalDiscountSet) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(variantKey, that.variantKey) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(priceId, that.priceId) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, variantKey, sku, priceId, discounted, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String variantKey;

    private String sku;

    private String priceId;

    private DiscountedProductPriceValue discounted;

    private Boolean staged;

    private String type;

    public ProductPriceExternalDiscountSet build() {
      ProductPriceExternalDiscountSet result = new ProductPriceExternalDiscountSet();
      result.variantId = this.variantId;
      result.variantKey = this.variantKey;
      result.sku = this.sku;
      result.priceId = this.priceId;
      result.discounted = this.discounted;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder variantKey(String variantKey) {
      this.variantKey = variantKey;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
