package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceKeySet implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private String priceId;

  private String oldKey;

  private String key;

  private Boolean staged;

  private String type;

  public ProductPriceKeySet() {
  }

  public ProductPriceKeySet(Integer variantId, String priceId, String oldKey, String key,
      Boolean staged, String type) {
    this.variantId = variantId;
    this.priceId = priceId;
    this.oldKey = oldKey;
    this.key = key;
    this.staged = staged;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public String getOldKey() {
    return oldKey;
  }

  public void setOldKey(String oldKey) {
    this.oldKey = oldKey;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceKeySet{variantId='" + variantId + "', priceId='" + priceId + "', oldKey='" + oldKey + "', key='" + key + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceKeySet that = (ProductPriceKeySet) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(priceId, that.priceId) &&
        Objects.equals(oldKey, that.oldKey) &&
        Objects.equals(key, that.key) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, priceId, oldKey, key, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String priceId;

    private String oldKey;

    private String key;

    private Boolean staged;

    private String type;

    public ProductPriceKeySet build() {
      ProductPriceKeySet result = new ProductPriceKeySet();
      result.variantId = this.variantId;
      result.priceId = this.priceId;
      result.oldKey = this.oldKey;
      result.key = this.key;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder oldKey(String oldKey) {
      this.oldKey = oldKey;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
