package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ProductPriceSearch {
  private String id;

  private BaseMoney value;

  private String key;

  private String country;

  private CustomerGroup customerGroup;

  private Reference customerGroupRef;

  private Channel channel;

  private Reference channelRef;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private DiscountedProductSearchPriceValue discounted;

  private List<ProductSearchPriceTier> tiers;

  private CustomFieldsType custom;

  public ProductPriceSearch() {
  }

  public ProductPriceSearch(String id, BaseMoney value, String key, String country,
      CustomerGroup customerGroup, Reference customerGroupRef, Channel channel,
      Reference channelRef, OffsetDateTime validFrom, OffsetDateTime validUntil,
      DiscountedProductSearchPriceValue discounted, List<ProductSearchPriceTier> tiers,
      CustomFieldsType custom) {
    this.id = id;
    this.value = value;
    this.key = key;
    this.country = country;
    this.customerGroup = customerGroup;
    this.customerGroupRef = customerGroupRef;
    this.channel = channel;
    this.channelRef = channelRef;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.discounted = discounted;
    this.tiers = tiers;
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public Channel getChannel() {
    return channel;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
  }

  public Reference getChannelRef() {
    return channelRef;
  }

  public void setChannelRef(Reference channelRef) {
    this.channelRef = channelRef;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public DiscountedProductSearchPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductSearchPriceValue discounted) {
    this.discounted = discounted;
  }

  public List<ProductSearchPriceTier> getTiers() {
    return tiers;
  }

  public void setTiers(List<ProductSearchPriceTier> tiers) {
    this.tiers = tiers;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ProductPriceSearch{id='" + id + "', value='" + value + "', key='" + key + "', country='" + country + "', customerGroup='" + customerGroup + "', customerGroupRef='" + customerGroupRef + "', channel='" + channel + "', channelRef='" + channelRef + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', discounted='" + discounted + "', tiers='" + tiers + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceSearch that = (ProductPriceSearch) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(value, that.value) &&
        Objects.equals(key, that.key) &&
        Objects.equals(country, that.country) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(channelRef, that.channelRef) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(tiers, that.tiers) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, value, key, country, customerGroup, customerGroupRef, channel, channelRef, validFrom, validUntil, discounted, tiers, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private BaseMoney value;

    private String key;

    private String country;

    private CustomerGroup customerGroup;

    private Reference customerGroupRef;

    private Channel channel;

    private Reference channelRef;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private DiscountedProductSearchPriceValue discounted;

    private List<ProductSearchPriceTier> tiers;

    private CustomFieldsType custom;

    public ProductPriceSearch build() {
      ProductPriceSearch result = new ProductPriceSearch();
      result.id = this.id;
      result.value = this.value;
      result.key = this.key;
      result.country = this.country;
      result.customerGroup = this.customerGroup;
      result.customerGroupRef = this.customerGroupRef;
      result.channel = this.channel;
      result.channelRef = this.channelRef;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.discounted = this.discounted;
      result.tiers = this.tiers;
      result.custom = this.custom;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder channel(Channel channel) {
      this.channel = channel;
      return this;
    }

    public Builder channelRef(Reference channelRef) {
      this.channelRef = channelRef;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder discounted(DiscountedProductSearchPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder tiers(List<ProductSearchPriceTier> tiers) {
      this.tiers = tiers;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }
  }
}
