package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPricesSet implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private List<ProductPrice> prices;

  private Boolean staged;

  private String type;

  public ProductPricesSet() {
  }

  public ProductPricesSet(Integer variantId, List<ProductPrice> prices, Boolean staged,
      String type) {
    this.variantId = variantId;
    this.prices = prices;
    this.staged = staged;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public List<ProductPrice> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPrice> prices) {
    this.prices = prices;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPricesSet{variantId='" + variantId + "', prices='" + prices + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPricesSet that = (ProductPricesSet) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, prices, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private List<ProductPrice> prices;

    private Boolean staged;

    private String type;

    public ProductPricesSet build() {
      ProductPricesSet result = new ProductPricesSet();
      result.variantId = this.variantId;
      result.prices = this.prices;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder prices(List<ProductPrice> prices) {
      this.prices = prices;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
