package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductProjectionSearchResult {
  private Integer offset;

  private Integer count;

  private Integer total;

  private List<ProductProjection> results;

  private List<FacetResultValue> facets;

  public ProductProjectionSearchResult() {
  }

  public ProductProjectionSearchResult(Integer offset, Integer count, Integer total,
      List<ProductProjection> results, List<FacetResultValue> facets) {
    this.offset = offset;
    this.count = count;
    this.total = total;
    this.results = results;
    this.facets = facets;
  }

  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public List<ProductProjection> getResults() {
    return results;
  }

  public void setResults(List<ProductProjection> results) {
    this.results = results;
  }

  public List<FacetResultValue> getFacets() {
    return facets;
  }

  public void setFacets(List<FacetResultValue> facets) {
    this.facets = facets;
  }

  @Override
  public String toString() {
    return "ProductProjectionSearchResult{offset='" + offset + "', count='" + count + "', total='" + total + "', results='" + results + "', facets='" + facets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductProjectionSearchResult that = (ProductProjectionSearchResult) o;
    return Objects.equals(offset, that.offset) &&
        Objects.equals(count, that.count) &&
        Objects.equals(total, that.total) &&
        Objects.equals(results, that.results) &&
        Objects.equals(facets, that.facets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(offset, count, total, results, facets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer offset;

    private Integer count;

    private Integer total;

    private List<ProductProjection> results;

    private List<FacetResultValue> facets;

    public ProductProjectionSearchResult build() {
      ProductProjectionSearchResult result = new ProductProjectionSearchResult();
      result.offset = this.offset;
      result.count = this.count;
      result.total = this.total;
      result.results = this.results;
      result.facets = this.facets;
      return result;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      return this;
    }

    public Builder count(Integer count) {
      this.count = count;
      return this;
    }

    public Builder total(Integer total) {
      this.total = total;
      return this;
    }

    public Builder results(List<ProductProjection> results) {
      this.results = results;
      return this;
    }

    public Builder facets(List<FacetResultValue> facets) {
      this.facets = facets;
      return this;
    }
  }
}
