package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductRevertedStagedChanges implements com.commercetools.graphql.api.types.MessagePayload {
  private Object removedImageUrls;

  private String type;

  public ProductRevertedStagedChanges() {
  }

  public ProductRevertedStagedChanges(Object removedImageUrls, String type) {
    this.removedImageUrls = removedImageUrls;
    this.type = type;
  }

  public Object getRemovedImageUrls() {
    return removedImageUrls;
  }

  public void setRemovedImageUrls(Object removedImageUrls) {
    this.removedImageUrls = removedImageUrls;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductRevertedStagedChanges{removedImageUrls='" + removedImageUrls + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductRevertedStagedChanges that = (ProductRevertedStagedChanges) o;
    return Objects.equals(removedImageUrls, that.removedImageUrls) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(removedImageUrls, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Object removedImageUrls;

    private String type;

    public ProductRevertedStagedChanges build() {
      ProductRevertedStagedChanges result = new ProductRevertedStagedChanges();
      result.removedImageUrls = this.removedImageUrls;
      result.type = this.type;
      return result;
    }

    public Builder removedImageUrls(Object removedImageUrls) {
      this.removedImageUrls = removedImageUrls;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
