package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSearchVariantAvailabilityWithChannels {
  private ProductSearchVariantAvailability noChannel;

  private ProductSearchVariantAvailabilitiesResult channels;

  public ProductSearchVariantAvailabilityWithChannels() {
  }

  public ProductSearchVariantAvailabilityWithChannels(ProductSearchVariantAvailability noChannel,
      ProductSearchVariantAvailabilitiesResult channels) {
    this.noChannel = noChannel;
    this.channels = channels;
  }

  public ProductSearchVariantAvailability getNoChannel() {
    return noChannel;
  }

  public void setNoChannel(ProductSearchVariantAvailability noChannel) {
    this.noChannel = noChannel;
  }

  public ProductSearchVariantAvailabilitiesResult getChannels() {
    return channels;
  }

  public void setChannels(ProductSearchVariantAvailabilitiesResult channels) {
    this.channels = channels;
  }

  @Override
  public String toString() {
    return "ProductSearchVariantAvailabilityWithChannels{noChannel='" + noChannel + "', channels='" + channels + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSearchVariantAvailabilityWithChannels that = (ProductSearchVariantAvailabilityWithChannels) o;
    return Objects.equals(noChannel, that.noChannel) &&
        Objects.equals(channels, that.channels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(noChannel, channels);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductSearchVariantAvailability noChannel;

    private ProductSearchVariantAvailabilitiesResult channels;

    public ProductSearchVariantAvailabilityWithChannels build() {
      ProductSearchVariantAvailabilityWithChannels result = new ProductSearchVariantAvailabilityWithChannels();
      result.noChannel = this.noChannel;
      result.channels = this.channels;
      return result;
    }

    public Builder noChannel(ProductSearchVariantAvailability noChannel) {
      this.noChannel = noChannel;
      return this;
    }

    public Builder channels(ProductSearchVariantAvailabilitiesResult channels) {
      this.channels = channels;
      return this;
    }
  }
}
