package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelection implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private ProductOfSelectionQueryResult productRefs;

  private Integer productCount;

  private CustomFieldsType custom;

  private ProductSelectionMode mode;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ProductSelection() {
  }

  public ProductSelection(String key, String name, List<LocalizedString> nameAllLocales,
      ProductOfSelectionQueryResult productRefs, Integer productCount, CustomFieldsType custom,
      ProductSelectionMode mode, String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.key = key;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.productRefs = productRefs;
    this.productCount = productCount;
    this.custom = custom;
    this.mode = mode;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public ProductOfSelectionQueryResult getProductRefs() {
    return productRefs;
  }

  public void setProductRefs(ProductOfSelectionQueryResult productRefs) {
    this.productRefs = productRefs;
  }

  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public ProductSelectionMode getMode() {
    return mode;
  }

  public void setMode(ProductSelectionMode mode) {
    this.mode = mode;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ProductSelection{key='" + key + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', productRefs='" + productRefs + "', productCount='" + productCount + "', custom='" + custom + "', mode='" + mode + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelection that = (ProductSelection) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(productRefs, that.productRefs) &&
        Objects.equals(productCount, that.productCount) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(mode, that.mode) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, nameAllLocales, productRefs, productCount, custom, mode, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private ProductOfSelectionQueryResult productRefs;

    private Integer productCount;

    private CustomFieldsType custom;

    private ProductSelectionMode mode;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ProductSelection build() {
      ProductSelection result = new ProductSelection();
      result.key = this.key;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.productRefs = this.productRefs;
      result.productCount = this.productCount;
      result.custom = this.custom;
      result.mode = this.mode;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder productRefs(ProductOfSelectionQueryResult productRefs) {
      this.productRefs = productRefs;
      return this;
    }

    public Builder productCount(Integer productCount) {
      this.productCount = productCount;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder mode(ProductSelectionMode mode) {
      this.mode = mode;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
