package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelectionProductAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductVariantSelection variantSelection;

  private Product product;

  private Reference productRef;

  private String type;

  public ProductSelectionProductAdded() {
  }

  public ProductSelectionProductAdded(ProductVariantSelection variantSelection, Product product,
      Reference productRef, String type) {
    this.variantSelection = variantSelection;
    this.product = product;
    this.productRef = productRef;
    this.type = type;
  }

  public ProductVariantSelection getVariantSelection() {
    return variantSelection;
  }

  public void setVariantSelection(ProductVariantSelection variantSelection) {
    this.variantSelection = variantSelection;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSelectionProductAdded{variantSelection='" + variantSelection + "', product='" + product + "', productRef='" + productRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionProductAdded that = (ProductSelectionProductAdded) o;
    return Objects.equals(variantSelection, that.variantSelection) &&
        Objects.equals(product, that.product) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantSelection, product, productRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductVariantSelection variantSelection;

    private Product product;

    private Reference productRef;

    private String type;

    public ProductSelectionProductAdded build() {
      ProductSelectionProductAdded result = new ProductSelectionProductAdded();
      result.variantSelection = this.variantSelection;
      result.product = this.product;
      result.productRef = this.productRef;
      result.type = this.type;
      return result;
    }

    public Builder variantSelection(ProductVariantSelection variantSelection) {
      this.variantSelection = variantSelection;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
