package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductSelectionQueryResult {
  private Integer offset;

  private Integer count;

  private Long total;

  private Boolean exists;

  private List<ProductSelection> results;

  public ProductSelectionQueryResult() {
  }

  public ProductSelectionQueryResult(Integer offset, Integer count, Long total, Boolean exists,
      List<ProductSelection> results) {
    this.offset = offset;
    this.count = count;
    this.total = total;
    this.exists = exists;
    this.results = results;
  }

  public Integer getOffset() {
    return offset;
  }

  public void setOffset(Integer offset) {
    this.offset = offset;
  }

  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  public Boolean getExists() {
    return exists;
  }

  public void setExists(Boolean exists) {
    this.exists = exists;
  }

  public List<ProductSelection> getResults() {
    return results;
  }

  public void setResults(List<ProductSelection> results) {
    this.results = results;
  }

  @Override
  public String toString() {
    return "ProductSelectionQueryResult{offset='" + offset + "', count='" + count + "', total='" + total + "', exists='" + exists + "', results='" + results + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionQueryResult that = (ProductSelectionQueryResult) o;
    return Objects.equals(offset, that.offset) &&
        Objects.equals(count, that.count) &&
        Objects.equals(total, that.total) &&
        Objects.equals(exists, that.exists) &&
        Objects.equals(results, that.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(offset, count, total, exists, results);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer offset;

    private Integer count;

    private Long total;

    private Boolean exists;

    private List<ProductSelection> results;

    public ProductSelectionQueryResult build() {
      ProductSelectionQueryResult result = new ProductSelectionQueryResult();
      result.offset = this.offset;
      result.count = this.count;
      result.total = this.total;
      result.exists = this.exists;
      result.results = this.results;
      return result;
    }

    public Builder offset(Integer offset) {
      this.offset = offset;
      return this;
    }

    public Builder count(Integer count) {
      this.count = count;
      return this;
    }

    public Builder total(Long total) {
      this.total = total;
      return this;
    }

    public Builder exists(Boolean exists) {
      this.exists = exists;
      return this;
    }

    public Builder results(List<ProductSelection> results) {
      this.results = results;
      return this;
    }
  }
}
