package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSelectionUpdateAction {
  private AddProductSelectionProduct addProduct;

  private ChangeProductSelectionName changeName;

  private ExcludeProductSelectionProduct excludeProduct;

  private RemoveProductSelectionProduct removeProduct;

  private SetProductSelectionCustomField setCustomField;

  private SetProductSelectionCustomType setCustomType;

  private SetProductSelectionKey setKey;

  private SetProductSelectionVariantExclusion setVariantExclusion;

  private SetProductSelectionVariantSelection setVariantSelection;

  public ProductSelectionUpdateAction() {
  }

  public ProductSelectionUpdateAction(AddProductSelectionProduct addProduct,
      ChangeProductSelectionName changeName, ExcludeProductSelectionProduct excludeProduct,
      RemoveProductSelectionProduct removeProduct, SetProductSelectionCustomField setCustomField,
      SetProductSelectionCustomType setCustomType, SetProductSelectionKey setKey,
      SetProductSelectionVariantExclusion setVariantExclusion,
      SetProductSelectionVariantSelection setVariantSelection) {
    this.addProduct = addProduct;
    this.changeName = changeName;
    this.excludeProduct = excludeProduct;
    this.removeProduct = removeProduct;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setKey = setKey;
    this.setVariantExclusion = setVariantExclusion;
    this.setVariantSelection = setVariantSelection;
  }

  public AddProductSelectionProduct getAddProduct() {
    return addProduct;
  }

  public void setAddProduct(AddProductSelectionProduct addProduct) {
    this.addProduct = addProduct;
  }

  public ChangeProductSelectionName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeProductSelectionName changeName) {
    this.changeName = changeName;
  }

  public ExcludeProductSelectionProduct getExcludeProduct() {
    return excludeProduct;
  }

  public void setExcludeProduct(ExcludeProductSelectionProduct excludeProduct) {
    this.excludeProduct = excludeProduct;
  }

  public RemoveProductSelectionProduct getRemoveProduct() {
    return removeProduct;
  }

  public void setRemoveProduct(RemoveProductSelectionProduct removeProduct) {
    this.removeProduct = removeProduct;
  }

  public SetProductSelectionCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetProductSelectionCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetProductSelectionCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetProductSelectionCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetProductSelectionKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetProductSelectionKey setKey) {
    this.setKey = setKey;
  }

  public SetProductSelectionVariantExclusion getSetVariantExclusion() {
    return setVariantExclusion;
  }

  public void setSetVariantExclusion(SetProductSelectionVariantExclusion setVariantExclusion) {
    this.setVariantExclusion = setVariantExclusion;
  }

  public SetProductSelectionVariantSelection getSetVariantSelection() {
    return setVariantSelection;
  }

  public void setSetVariantSelection(SetProductSelectionVariantSelection setVariantSelection) {
    this.setVariantSelection = setVariantSelection;
  }

  @Override
  public String toString() {
    return "ProductSelectionUpdateAction{addProduct='" + addProduct + "', changeName='" + changeName + "', excludeProduct='" + excludeProduct + "', removeProduct='" + removeProduct + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setKey='" + setKey + "', setVariantExclusion='" + setVariantExclusion + "', setVariantSelection='" + setVariantSelection + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionUpdateAction that = (ProductSelectionUpdateAction) o;
    return Objects.equals(addProduct, that.addProduct) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(excludeProduct, that.excludeProduct) &&
        Objects.equals(removeProduct, that.removeProduct) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setVariantExclusion, that.setVariantExclusion) &&
        Objects.equals(setVariantSelection, that.setVariantSelection);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addProduct, changeName, excludeProduct, removeProduct, setCustomField, setCustomType, setKey, setVariantExclusion, setVariantSelection);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddProductSelectionProduct addProduct;

    private ChangeProductSelectionName changeName;

    private ExcludeProductSelectionProduct excludeProduct;

    private RemoveProductSelectionProduct removeProduct;

    private SetProductSelectionCustomField setCustomField;

    private SetProductSelectionCustomType setCustomType;

    private SetProductSelectionKey setKey;

    private SetProductSelectionVariantExclusion setVariantExclusion;

    private SetProductSelectionVariantSelection setVariantSelection;

    public ProductSelectionUpdateAction build() {
      ProductSelectionUpdateAction result = new ProductSelectionUpdateAction();
      result.addProduct = this.addProduct;
      result.changeName = this.changeName;
      result.excludeProduct = this.excludeProduct;
      result.removeProduct = this.removeProduct;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setKey = this.setKey;
      result.setVariantExclusion = this.setVariantExclusion;
      result.setVariantSelection = this.setVariantSelection;
      return result;
    }

    public Builder addProduct(AddProductSelectionProduct addProduct) {
      this.addProduct = addProduct;
      return this;
    }

    public Builder changeName(ChangeProductSelectionName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder excludeProduct(ExcludeProductSelectionProduct excludeProduct) {
      this.excludeProduct = excludeProduct;
      return this;
    }

    public Builder removeProduct(RemoveProductSelectionProduct removeProduct) {
      this.removeProduct = removeProduct;
      return this;
    }

    public Builder setCustomField(SetProductSelectionCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetProductSelectionCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setKey(SetProductSelectionKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setVariantExclusion(SetProductSelectionVariantExclusion setVariantExclusion) {
      this.setVariantExclusion = setVariantExclusion;
      return this;
    }

    public Builder setVariantSelection(SetProductSelectionVariantSelection setVariantSelection) {
      this.setVariantSelection = setVariantSelection;
      return this;
    }
  }
}
