package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelectionVariantSelectionChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductVariantSelection oldVariantSelection;

  private ProductVariantSelection newVariantSelection;

  private Product product;

  private Reference productRef;

  private String type;

  public ProductSelectionVariantSelectionChanged() {
  }

  public ProductSelectionVariantSelectionChanged(ProductVariantSelection oldVariantSelection,
      ProductVariantSelection newVariantSelection, Product product, Reference productRef,
      String type) {
    this.oldVariantSelection = oldVariantSelection;
    this.newVariantSelection = newVariantSelection;
    this.product = product;
    this.productRef = productRef;
    this.type = type;
  }

  public ProductVariantSelection getOldVariantSelection() {
    return oldVariantSelection;
  }

  public void setOldVariantSelection(ProductVariantSelection oldVariantSelection) {
    this.oldVariantSelection = oldVariantSelection;
  }

  public ProductVariantSelection getNewVariantSelection() {
    return newVariantSelection;
  }

  public void setNewVariantSelection(ProductVariantSelection newVariantSelection) {
    this.newVariantSelection = newVariantSelection;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSelectionVariantSelectionChanged{oldVariantSelection='" + oldVariantSelection + "', newVariantSelection='" + newVariantSelection + "', product='" + product + "', productRef='" + productRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionVariantSelectionChanged that = (ProductSelectionVariantSelectionChanged) o;
    return Objects.equals(oldVariantSelection, that.oldVariantSelection) &&
        Objects.equals(newVariantSelection, that.newVariantSelection) &&
        Objects.equals(product, that.product) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldVariantSelection, newVariantSelection, product, productRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductVariantSelection oldVariantSelection;

    private ProductVariantSelection newVariantSelection;

    private Product product;

    private Reference productRef;

    private String type;

    public ProductSelectionVariantSelectionChanged build() {
      ProductSelectionVariantSelectionChanged result = new ProductSelectionVariantSelectionChanged();
      result.oldVariantSelection = this.oldVariantSelection;
      result.newVariantSelection = this.newVariantSelection;
      result.product = this.product;
      result.productRef = this.productRef;
      result.type = this.type;
      return result;
    }

    public Builder oldVariantSelection(ProductVariantSelection oldVariantSelection) {
      this.oldVariantSelection = oldVariantSelection;
      return this;
    }

    public Builder newVariantSelection(ProductVariantSelection newVariantSelection) {
      this.newVariantSelection = newVariantSelection;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
