package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSlugChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String slug;

  private String oldSlug;

  private List<LocalizedString> slugAllLocales;

  private List<LocalizedString> oldSlugAllLocales;

  private String type;

  public ProductSlugChanged() {
  }

  public ProductSlugChanged(String slug, String oldSlug, List<LocalizedString> slugAllLocales,
      List<LocalizedString> oldSlugAllLocales, String type) {
    this.slug = slug;
    this.oldSlug = oldSlug;
    this.slugAllLocales = slugAllLocales;
    this.oldSlugAllLocales = oldSlugAllLocales;
    this.type = type;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public String getOldSlug() {
    return oldSlug;
  }

  public void setOldSlug(String oldSlug) {
    this.oldSlug = oldSlug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public List<LocalizedString> getOldSlugAllLocales() {
    return oldSlugAllLocales;
  }

  public void setOldSlugAllLocales(List<LocalizedString> oldSlugAllLocales) {
    this.oldSlugAllLocales = oldSlugAllLocales;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSlugChanged{slug='" + slug + "', oldSlug='" + oldSlug + "', slugAllLocales='" + slugAllLocales + "', oldSlugAllLocales='" + oldSlugAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSlugChanged that = (ProductSlugChanged) o;
    return Objects.equals(slug, that.slug) &&
        Objects.equals(oldSlug, that.oldSlug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(oldSlugAllLocales, that.oldSlugAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(slug, oldSlug, slugAllLocales, oldSlugAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String slug;

    private String oldSlug;

    private List<LocalizedString> slugAllLocales;

    private List<LocalizedString> oldSlugAllLocales;

    private String type;

    public ProductSlugChanged build() {
      ProductSlugChanged result = new ProductSlugChanged();
      result.slug = this.slug;
      result.oldSlug = this.oldSlug;
      result.slugAllLocales = this.slugAllLocales;
      result.oldSlugAllLocales = this.oldSlugAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder oldSlug(String oldSlug) {
      this.oldSlug = oldSlug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder oldSlugAllLocales(List<LocalizedString> oldSlugAllLocales) {
      this.oldSlugAllLocales = oldSlugAllLocales;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
