package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoring implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private Reference productRef;

  private Product product;

  private KeyReference storeRef;

  private Store store;

  private ProductTailoringData current;

  private ProductTailoringData staged;

  private Boolean published;

  private Boolean hasStagedChanges;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ProductTailoring() {
  }

  public ProductTailoring(String key, Reference productRef, Product product, KeyReference storeRef,
      Store store, ProductTailoringData current, ProductTailoringData staged, Boolean published,
      Boolean hasStagedChanges, String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.key = key;
    this.productRef = productRef;
    this.product = product;
    this.storeRef = storeRef;
    this.store = store;
    this.current = current;
    this.staged = staged;
    this.published = published;
    this.hasStagedChanges = hasStagedChanges;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public ProductTailoringData getCurrent() {
    return current;
  }

  public void setCurrent(ProductTailoringData current) {
    this.current = current;
  }

  public ProductTailoringData getStaged() {
    return staged;
  }

  public void setStaged(ProductTailoringData staged) {
    this.staged = staged;
  }

  public Boolean getPublished() {
    return published;
  }

  public void setPublished(Boolean published) {
    this.published = published;
  }

  public Boolean getHasStagedChanges() {
    return hasStagedChanges;
  }

  public void setHasStagedChanges(Boolean hasStagedChanges) {
    this.hasStagedChanges = hasStagedChanges;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ProductTailoring{key='" + key + "', productRef='" + productRef + "', product='" + product + "', storeRef='" + storeRef + "', store='" + store + "', current='" + current + "', staged='" + staged + "', published='" + published + "', hasStagedChanges='" + hasStagedChanges + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoring that = (ProductTailoring) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(product, that.product) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(store, that.store) &&
        Objects.equals(current, that.current) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(published, that.published) &&
        Objects.equals(hasStagedChanges, that.hasStagedChanges) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, productRef, product, storeRef, store, current, staged, published, hasStagedChanges, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private Reference productRef;

    private Product product;

    private KeyReference storeRef;

    private Store store;

    private ProductTailoringData current;

    private ProductTailoringData staged;

    private Boolean published;

    private Boolean hasStagedChanges;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ProductTailoring build() {
      ProductTailoring result = new ProductTailoring();
      result.key = this.key;
      result.productRef = this.productRef;
      result.product = this.product;
      result.storeRef = this.storeRef;
      result.store = this.store;
      result.current = this.current;
      result.staged = this.staged;
      result.published = this.published;
      result.hasStagedChanges = this.hasStagedChanges;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder current(ProductTailoringData current) {
      this.current = current;
      return this;
    }

    public Builder staged(ProductTailoringData staged) {
      this.staged = staged;
      return this;
    }

    public Builder published(Boolean published) {
      this.published = published;
      return this;
    }

    public Builder hasStagedChanges(Boolean hasStagedChanges) {
      this.hasStagedChanges = hasStagedChanges;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
