package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringDeleted implements com.commercetools.graphql.api.types.MessagePayload {
  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private String type;

  public ProductTailoringDeleted() {
  }

  public ProductTailoringDeleted(KeyReference storeRef, Reference productRef, String productKey,
      String type) {
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.type = type;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringDeleted{storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringDeleted that = (ProductTailoringDeleted) o;
    return Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storeRef, productRef, productKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private String type;

    public ProductTailoringDeleted build() {
      ProductTailoringDeleted result = new ProductTailoringDeleted();
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.type = this.type;
      return result;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
