package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringImagesSet implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private List<Image> oldImages;

  private List<Image> images;

  private String type;

  public ProductTailoringImagesSet() {
  }

  public ProductTailoringImagesSet(Integer variantId, KeyReference storeRef, Reference productRef,
      String productKey, List<Image> oldImages, List<Image> images, String type) {
    this.variantId = variantId;
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.oldImages = oldImages;
    this.images = images;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public List<Image> getOldImages() {
    return oldImages;
  }

  public void setOldImages(List<Image> oldImages) {
    this.oldImages = oldImages;
  }

  public List<Image> getImages() {
    return images;
  }

  public void setImages(List<Image> images) {
    this.images = images;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringImagesSet{variantId='" + variantId + "', storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', oldImages='" + oldImages + "', images='" + images + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringImagesSet that = (ProductTailoringImagesSet) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(oldImages, that.oldImages) &&
        Objects.equals(images, that.images) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, storeRef, productRef, productKey, oldImages, images, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private List<Image> oldImages;

    private List<Image> images;

    private String type;

    public ProductTailoringImagesSet build() {
      ProductTailoringImagesSet result = new ProductTailoringImagesSet();
      result.variantId = this.variantId;
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.oldImages = this.oldImages;
      result.images = this.images;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder oldImages(List<Image> oldImages) {
      this.oldImages = oldImages;
      return this;
    }

    public Builder images(List<Image> images) {
      this.images = images;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
