package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private String name;

  private String oldName;

  private List<LocalizedString> nameAllLocales;

  private List<LocalizedString> oldNameAllLocales;

  private String type;

  public ProductTailoringNameSet() {
  }

  public ProductTailoringNameSet(KeyReference storeRef, Reference productRef, String productKey,
      String name, String oldName, List<LocalizedString> nameAllLocales,
      List<LocalizedString> oldNameAllLocales, String type) {
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.name = name;
    this.oldName = oldName;
    this.nameAllLocales = nameAllLocales;
    this.oldNameAllLocales = oldNameAllLocales;
    this.type = type;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getOldName() {
    return oldName;
  }

  public void setOldName(String oldName) {
    this.oldName = oldName;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<LocalizedString> getOldNameAllLocales() {
    return oldNameAllLocales;
  }

  public void setOldNameAllLocales(List<LocalizedString> oldNameAllLocales) {
    this.oldNameAllLocales = oldNameAllLocales;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringNameSet{storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', name='" + name + "', oldName='" + oldName + "', nameAllLocales='" + nameAllLocales + "', oldNameAllLocales='" + oldNameAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringNameSet that = (ProductTailoringNameSet) o;
    return Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(oldName, that.oldName) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(oldNameAllLocales, that.oldNameAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storeRef, productRef, productKey, name, oldName, nameAllLocales, oldNameAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private String name;

    private String oldName;

    private List<LocalizedString> nameAllLocales;

    private List<LocalizedString> oldNameAllLocales;

    private String type;

    public ProductTailoringNameSet build() {
      ProductTailoringNameSet result = new ProductTailoringNameSet();
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.name = this.name;
      result.oldName = this.oldName;
      result.nameAllLocales = this.nameAllLocales;
      result.oldNameAllLocales = this.oldNameAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder oldName(String oldName) {
      this.oldName = oldName;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder oldNameAllLocales(List<LocalizedString> oldNameAllLocales) {
      this.oldNameAllLocales = oldNameAllLocales;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
