package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductUpdateAction {
  private MoveProductImageToPosition moveImageToPosition;

  private SetSearchKeywords setSearchKeywords;

  private RevertStagedChanges revertStagedChanges;

  private RevertStagedVariantChanges revertStagedVariantChanges;

  private PublishProduct publish;

  private UnpublishProduct unpublish;

  private TransitionProductState transitionState;

  private RemoveProductPrice removePrice;

  private AddProductAsset addAsset;

  private AddProductExternalImage addExternalImage;

  private AddProductPrice addPrice;

  private AddProductToCategory addToCategory;

  private AddProductVariant addVariant;

  private ChangeProductAssetName changeAssetName;

  private ChangeProductAssetOrder changeAssetOrder;

  private ChangeProductMasterVariant changeMasterVariant;

  private ChangeProductImageLabel changeImageLabel;

  private ChangeProductName changeName;

  private ChangeProductPrice changePrice;

  private ChangeProductSlug changeSlug;

  private RemoveProductAsset removeAsset;

  private RemoveProductFromCategory removeFromCategory;

  private RemoveProductImage removeImage;

  private RemoveProductVariant removeVariant;

  private SetProductAssetCustomField setAssetCustomField;

  private SetProductAssetCustomType setAssetCustomType;

  private SetProductAssetDescription setAssetDescription;

  private SetProductAssetKey setAssetKey;

  private SetProductAssetSources setAssetSources;

  private SetProductAssetTags setAssetTags;

  private SetProductCategoryOrderHint setCategoryOrderHint;

  private SetProductDiscountedPrice setDiscountedPrice;

  private SetProductAttribute setAttribute;

  private SetProductAttributeInAllVariants setAttributeInAllVariants;

  private SetProductDescription setDescription;

  private SetProductImageLabel setImageLabel;

  private SetProductKey setKey;

  private SetProductMetaAttributes setMetaAttributes;

  private SetProductMetaDescription setMetaDescription;

  private SetProductMetaKeywords setMetaKeywords;

  private SetProductMetaTitle setMetaTitle;

  private SetProductPriceCustomField setProductPriceCustomField;

  private SetProductPriceCustomType setProductPriceCustomType;

  private SetProductPriceKey setPriceKey;

  private SetProductPriceMode setPriceMode;

  private SetProductPrices setPrices;

  private SetProductSku setSku;

  private SetProductTaxCategory setTaxCategory;

  private SetProductVariantKey setProductVariantKey;

  public ProductUpdateAction() {
  }

  public ProductUpdateAction(MoveProductImageToPosition moveImageToPosition,
      SetSearchKeywords setSearchKeywords, RevertStagedChanges revertStagedChanges,
      RevertStagedVariantChanges revertStagedVariantChanges, PublishProduct publish,
      UnpublishProduct unpublish, TransitionProductState transitionState,
      RemoveProductPrice removePrice, AddProductAsset addAsset,
      AddProductExternalImage addExternalImage, AddProductPrice addPrice,
      AddProductToCategory addToCategory, AddProductVariant addVariant,
      ChangeProductAssetName changeAssetName, ChangeProductAssetOrder changeAssetOrder,
      ChangeProductMasterVariant changeMasterVariant, ChangeProductImageLabel changeImageLabel,
      ChangeProductName changeName, ChangeProductPrice changePrice, ChangeProductSlug changeSlug,
      RemoveProductAsset removeAsset, RemoveProductFromCategory removeFromCategory,
      RemoveProductImage removeImage, RemoveProductVariant removeVariant,
      SetProductAssetCustomField setAssetCustomField, SetProductAssetCustomType setAssetCustomType,
      SetProductAssetDescription setAssetDescription, SetProductAssetKey setAssetKey,
      SetProductAssetSources setAssetSources, SetProductAssetTags setAssetTags,
      SetProductCategoryOrderHint setCategoryOrderHint,
      SetProductDiscountedPrice setDiscountedPrice, SetProductAttribute setAttribute,
      SetProductAttributeInAllVariants setAttributeInAllVariants,
      SetProductDescription setDescription, SetProductImageLabel setImageLabel,
      SetProductKey setKey, SetProductMetaAttributes setMetaAttributes,
      SetProductMetaDescription setMetaDescription, SetProductMetaKeywords setMetaKeywords,
      SetProductMetaTitle setMetaTitle, SetProductPriceCustomField setProductPriceCustomField,
      SetProductPriceCustomType setProductPriceCustomType, SetProductPriceKey setPriceKey,
      SetProductPriceMode setPriceMode, SetProductPrices setPrices, SetProductSku setSku,
      SetProductTaxCategory setTaxCategory, SetProductVariantKey setProductVariantKey) {
    this.moveImageToPosition = moveImageToPosition;
    this.setSearchKeywords = setSearchKeywords;
    this.revertStagedChanges = revertStagedChanges;
    this.revertStagedVariantChanges = revertStagedVariantChanges;
    this.publish = publish;
    this.unpublish = unpublish;
    this.transitionState = transitionState;
    this.removePrice = removePrice;
    this.addAsset = addAsset;
    this.addExternalImage = addExternalImage;
    this.addPrice = addPrice;
    this.addToCategory = addToCategory;
    this.addVariant = addVariant;
    this.changeAssetName = changeAssetName;
    this.changeAssetOrder = changeAssetOrder;
    this.changeMasterVariant = changeMasterVariant;
    this.changeImageLabel = changeImageLabel;
    this.changeName = changeName;
    this.changePrice = changePrice;
    this.changeSlug = changeSlug;
    this.removeAsset = removeAsset;
    this.removeFromCategory = removeFromCategory;
    this.removeImage = removeImage;
    this.removeVariant = removeVariant;
    this.setAssetCustomField = setAssetCustomField;
    this.setAssetCustomType = setAssetCustomType;
    this.setAssetDescription = setAssetDescription;
    this.setAssetKey = setAssetKey;
    this.setAssetSources = setAssetSources;
    this.setAssetTags = setAssetTags;
    this.setCategoryOrderHint = setCategoryOrderHint;
    this.setDiscountedPrice = setDiscountedPrice;
    this.setAttribute = setAttribute;
    this.setAttributeInAllVariants = setAttributeInAllVariants;
    this.setDescription = setDescription;
    this.setImageLabel = setImageLabel;
    this.setKey = setKey;
    this.setMetaAttributes = setMetaAttributes;
    this.setMetaDescription = setMetaDescription;
    this.setMetaKeywords = setMetaKeywords;
    this.setMetaTitle = setMetaTitle;
    this.setProductPriceCustomField = setProductPriceCustomField;
    this.setProductPriceCustomType = setProductPriceCustomType;
    this.setPriceKey = setPriceKey;
    this.setPriceMode = setPriceMode;
    this.setPrices = setPrices;
    this.setSku = setSku;
    this.setTaxCategory = setTaxCategory;
    this.setProductVariantKey = setProductVariantKey;
  }

  public MoveProductImageToPosition getMoveImageToPosition() {
    return moveImageToPosition;
  }

  public void setMoveImageToPosition(MoveProductImageToPosition moveImageToPosition) {
    this.moveImageToPosition = moveImageToPosition;
  }

  public SetSearchKeywords getSetSearchKeywords() {
    return setSearchKeywords;
  }

  public void setSetSearchKeywords(SetSearchKeywords setSearchKeywords) {
    this.setSearchKeywords = setSearchKeywords;
  }

  public RevertStagedChanges getRevertStagedChanges() {
    return revertStagedChanges;
  }

  public void setRevertStagedChanges(RevertStagedChanges revertStagedChanges) {
    this.revertStagedChanges = revertStagedChanges;
  }

  public RevertStagedVariantChanges getRevertStagedVariantChanges() {
    return revertStagedVariantChanges;
  }

  public void setRevertStagedVariantChanges(RevertStagedVariantChanges revertStagedVariantChanges) {
    this.revertStagedVariantChanges = revertStagedVariantChanges;
  }

  public PublishProduct getPublish() {
    return publish;
  }

  public void setPublish(PublishProduct publish) {
    this.publish = publish;
  }

  public UnpublishProduct getUnpublish() {
    return unpublish;
  }

  public void setUnpublish(UnpublishProduct unpublish) {
    this.unpublish = unpublish;
  }

  public TransitionProductState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionProductState transitionState) {
    this.transitionState = transitionState;
  }

  public RemoveProductPrice getRemovePrice() {
    return removePrice;
  }

  public void setRemovePrice(RemoveProductPrice removePrice) {
    this.removePrice = removePrice;
  }

  public AddProductAsset getAddAsset() {
    return addAsset;
  }

  public void setAddAsset(AddProductAsset addAsset) {
    this.addAsset = addAsset;
  }

  public AddProductExternalImage getAddExternalImage() {
    return addExternalImage;
  }

  public void setAddExternalImage(AddProductExternalImage addExternalImage) {
    this.addExternalImage = addExternalImage;
  }

  public AddProductPrice getAddPrice() {
    return addPrice;
  }

  public void setAddPrice(AddProductPrice addPrice) {
    this.addPrice = addPrice;
  }

  public AddProductToCategory getAddToCategory() {
    return addToCategory;
  }

  public void setAddToCategory(AddProductToCategory addToCategory) {
    this.addToCategory = addToCategory;
  }

  public AddProductVariant getAddVariant() {
    return addVariant;
  }

  public void setAddVariant(AddProductVariant addVariant) {
    this.addVariant = addVariant;
  }

  public ChangeProductAssetName getChangeAssetName() {
    return changeAssetName;
  }

  public void setChangeAssetName(ChangeProductAssetName changeAssetName) {
    this.changeAssetName = changeAssetName;
  }

  public ChangeProductAssetOrder getChangeAssetOrder() {
    return changeAssetOrder;
  }

  public void setChangeAssetOrder(ChangeProductAssetOrder changeAssetOrder) {
    this.changeAssetOrder = changeAssetOrder;
  }

  public ChangeProductMasterVariant getChangeMasterVariant() {
    return changeMasterVariant;
  }

  public void setChangeMasterVariant(ChangeProductMasterVariant changeMasterVariant) {
    this.changeMasterVariant = changeMasterVariant;
  }

  public ChangeProductImageLabel getChangeImageLabel() {
    return changeImageLabel;
  }

  public void setChangeImageLabel(ChangeProductImageLabel changeImageLabel) {
    this.changeImageLabel = changeImageLabel;
  }

  public ChangeProductName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeProductName changeName) {
    this.changeName = changeName;
  }

  public ChangeProductPrice getChangePrice() {
    return changePrice;
  }

  public void setChangePrice(ChangeProductPrice changePrice) {
    this.changePrice = changePrice;
  }

  public ChangeProductSlug getChangeSlug() {
    return changeSlug;
  }

  public void setChangeSlug(ChangeProductSlug changeSlug) {
    this.changeSlug = changeSlug;
  }

  public RemoveProductAsset getRemoveAsset() {
    return removeAsset;
  }

  public void setRemoveAsset(RemoveProductAsset removeAsset) {
    this.removeAsset = removeAsset;
  }

  public RemoveProductFromCategory getRemoveFromCategory() {
    return removeFromCategory;
  }

  public void setRemoveFromCategory(RemoveProductFromCategory removeFromCategory) {
    this.removeFromCategory = removeFromCategory;
  }

  public RemoveProductImage getRemoveImage() {
    return removeImage;
  }

  public void setRemoveImage(RemoveProductImage removeImage) {
    this.removeImage = removeImage;
  }

  public RemoveProductVariant getRemoveVariant() {
    return removeVariant;
  }

  public void setRemoveVariant(RemoveProductVariant removeVariant) {
    this.removeVariant = removeVariant;
  }

  public SetProductAssetCustomField getSetAssetCustomField() {
    return setAssetCustomField;
  }

  public void setSetAssetCustomField(SetProductAssetCustomField setAssetCustomField) {
    this.setAssetCustomField = setAssetCustomField;
  }

  public SetProductAssetCustomType getSetAssetCustomType() {
    return setAssetCustomType;
  }

  public void setSetAssetCustomType(SetProductAssetCustomType setAssetCustomType) {
    this.setAssetCustomType = setAssetCustomType;
  }

  public SetProductAssetDescription getSetAssetDescription() {
    return setAssetDescription;
  }

  public void setSetAssetDescription(SetProductAssetDescription setAssetDescription) {
    this.setAssetDescription = setAssetDescription;
  }

  public SetProductAssetKey getSetAssetKey() {
    return setAssetKey;
  }

  public void setSetAssetKey(SetProductAssetKey setAssetKey) {
    this.setAssetKey = setAssetKey;
  }

  public SetProductAssetSources getSetAssetSources() {
    return setAssetSources;
  }

  public void setSetAssetSources(SetProductAssetSources setAssetSources) {
    this.setAssetSources = setAssetSources;
  }

  public SetProductAssetTags getSetAssetTags() {
    return setAssetTags;
  }

  public void setSetAssetTags(SetProductAssetTags setAssetTags) {
    this.setAssetTags = setAssetTags;
  }

  public SetProductCategoryOrderHint getSetCategoryOrderHint() {
    return setCategoryOrderHint;
  }

  public void setSetCategoryOrderHint(SetProductCategoryOrderHint setCategoryOrderHint) {
    this.setCategoryOrderHint = setCategoryOrderHint;
  }

  public SetProductDiscountedPrice getSetDiscountedPrice() {
    return setDiscountedPrice;
  }

  public void setSetDiscountedPrice(SetProductDiscountedPrice setDiscountedPrice) {
    this.setDiscountedPrice = setDiscountedPrice;
  }

  public SetProductAttribute getSetAttribute() {
    return setAttribute;
  }

  public void setSetAttribute(SetProductAttribute setAttribute) {
    this.setAttribute = setAttribute;
  }

  public SetProductAttributeInAllVariants getSetAttributeInAllVariants() {
    return setAttributeInAllVariants;
  }

  public void setSetAttributeInAllVariants(
      SetProductAttributeInAllVariants setAttributeInAllVariants) {
    this.setAttributeInAllVariants = setAttributeInAllVariants;
  }

  public SetProductDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetProductDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetProductImageLabel getSetImageLabel() {
    return setImageLabel;
  }

  public void setSetImageLabel(SetProductImageLabel setImageLabel) {
    this.setImageLabel = setImageLabel;
  }

  public SetProductKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetProductKey setKey) {
    this.setKey = setKey;
  }

  public SetProductMetaAttributes getSetMetaAttributes() {
    return setMetaAttributes;
  }

  public void setSetMetaAttributes(SetProductMetaAttributes setMetaAttributes) {
    this.setMetaAttributes = setMetaAttributes;
  }

  public SetProductMetaDescription getSetMetaDescription() {
    return setMetaDescription;
  }

  public void setSetMetaDescription(SetProductMetaDescription setMetaDescription) {
    this.setMetaDescription = setMetaDescription;
  }

  public SetProductMetaKeywords getSetMetaKeywords() {
    return setMetaKeywords;
  }

  public void setSetMetaKeywords(SetProductMetaKeywords setMetaKeywords) {
    this.setMetaKeywords = setMetaKeywords;
  }

  public SetProductMetaTitle getSetMetaTitle() {
    return setMetaTitle;
  }

  public void setSetMetaTitle(SetProductMetaTitle setMetaTitle) {
    this.setMetaTitle = setMetaTitle;
  }

  public SetProductPriceCustomField getSetProductPriceCustomField() {
    return setProductPriceCustomField;
  }

  public void setSetProductPriceCustomField(SetProductPriceCustomField setProductPriceCustomField) {
    this.setProductPriceCustomField = setProductPriceCustomField;
  }

  public SetProductPriceCustomType getSetProductPriceCustomType() {
    return setProductPriceCustomType;
  }

  public void setSetProductPriceCustomType(SetProductPriceCustomType setProductPriceCustomType) {
    this.setProductPriceCustomType = setProductPriceCustomType;
  }

  public SetProductPriceKey getSetPriceKey() {
    return setPriceKey;
  }

  public void setSetPriceKey(SetProductPriceKey setPriceKey) {
    this.setPriceKey = setPriceKey;
  }

  public SetProductPriceMode getSetPriceMode() {
    return setPriceMode;
  }

  public void setSetPriceMode(SetProductPriceMode setPriceMode) {
    this.setPriceMode = setPriceMode;
  }

  public SetProductPrices getSetPrices() {
    return setPrices;
  }

  public void setSetPrices(SetProductPrices setPrices) {
    this.setPrices = setPrices;
  }

  public SetProductSku getSetSku() {
    return setSku;
  }

  public void setSetSku(SetProductSku setSku) {
    this.setSku = setSku;
  }

  public SetProductTaxCategory getSetTaxCategory() {
    return setTaxCategory;
  }

  public void setSetTaxCategory(SetProductTaxCategory setTaxCategory) {
    this.setTaxCategory = setTaxCategory;
  }

  public SetProductVariantKey getSetProductVariantKey() {
    return setProductVariantKey;
  }

  public void setSetProductVariantKey(SetProductVariantKey setProductVariantKey) {
    this.setProductVariantKey = setProductVariantKey;
  }

  @Override
  public String toString() {
    return "ProductUpdateAction{moveImageToPosition='" + moveImageToPosition + "', setSearchKeywords='" + setSearchKeywords + "', revertStagedChanges='" + revertStagedChanges + "', revertStagedVariantChanges='" + revertStagedVariantChanges + "', publish='" + publish + "', unpublish='" + unpublish + "', transitionState='" + transitionState + "', removePrice='" + removePrice + "', addAsset='" + addAsset + "', addExternalImage='" + addExternalImage + "', addPrice='" + addPrice + "', addToCategory='" + addToCategory + "', addVariant='" + addVariant + "', changeAssetName='" + changeAssetName + "', changeAssetOrder='" + changeAssetOrder + "', changeMasterVariant='" + changeMasterVariant + "', changeImageLabel='" + changeImageLabel + "', changeName='" + changeName + "', changePrice='" + changePrice + "', changeSlug='" + changeSlug + "', removeAsset='" + removeAsset + "', removeFromCategory='" + removeFromCategory + "', removeImage='" + removeImage + "', removeVariant='" + removeVariant + "', setAssetCustomField='" + setAssetCustomField + "', setAssetCustomType='" + setAssetCustomType + "', setAssetDescription='" + setAssetDescription + "', setAssetKey='" + setAssetKey + "', setAssetSources='" + setAssetSources + "', setAssetTags='" + setAssetTags + "', setCategoryOrderHint='" + setCategoryOrderHint + "', setDiscountedPrice='" + setDiscountedPrice + "', setAttribute='" + setAttribute + "', setAttributeInAllVariants='" + setAttributeInAllVariants + "', setDescription='" + setDescription + "', setImageLabel='" + setImageLabel + "', setKey='" + setKey + "', setMetaAttributes='" + setMetaAttributes + "', setMetaDescription='" + setMetaDescription + "', setMetaKeywords='" + setMetaKeywords + "', setMetaTitle='" + setMetaTitle + "', setProductPriceCustomField='" + setProductPriceCustomField + "', setProductPriceCustomType='" + setProductPriceCustomType + "', setPriceKey='" + setPriceKey + "', setPriceMode='" + setPriceMode + "', setPrices='" + setPrices + "', setSku='" + setSku + "', setTaxCategory='" + setTaxCategory + "', setProductVariantKey='" + setProductVariantKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductUpdateAction that = (ProductUpdateAction) o;
    return Objects.equals(moveImageToPosition, that.moveImageToPosition) &&
        Objects.equals(setSearchKeywords, that.setSearchKeywords) &&
        Objects.equals(revertStagedChanges, that.revertStagedChanges) &&
        Objects.equals(revertStagedVariantChanges, that.revertStagedVariantChanges) &&
        Objects.equals(publish, that.publish) &&
        Objects.equals(unpublish, that.unpublish) &&
        Objects.equals(transitionState, that.transitionState) &&
        Objects.equals(removePrice, that.removePrice) &&
        Objects.equals(addAsset, that.addAsset) &&
        Objects.equals(addExternalImage, that.addExternalImage) &&
        Objects.equals(addPrice, that.addPrice) &&
        Objects.equals(addToCategory, that.addToCategory) &&
        Objects.equals(addVariant, that.addVariant) &&
        Objects.equals(changeAssetName, that.changeAssetName) &&
        Objects.equals(changeAssetOrder, that.changeAssetOrder) &&
        Objects.equals(changeMasterVariant, that.changeMasterVariant) &&
        Objects.equals(changeImageLabel, that.changeImageLabel) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changePrice, that.changePrice) &&
        Objects.equals(changeSlug, that.changeSlug) &&
        Objects.equals(removeAsset, that.removeAsset) &&
        Objects.equals(removeFromCategory, that.removeFromCategory) &&
        Objects.equals(removeImage, that.removeImage) &&
        Objects.equals(removeVariant, that.removeVariant) &&
        Objects.equals(setAssetCustomField, that.setAssetCustomField) &&
        Objects.equals(setAssetCustomType, that.setAssetCustomType) &&
        Objects.equals(setAssetDescription, that.setAssetDescription) &&
        Objects.equals(setAssetKey, that.setAssetKey) &&
        Objects.equals(setAssetSources, that.setAssetSources) &&
        Objects.equals(setAssetTags, that.setAssetTags) &&
        Objects.equals(setCategoryOrderHint, that.setCategoryOrderHint) &&
        Objects.equals(setDiscountedPrice, that.setDiscountedPrice) &&
        Objects.equals(setAttribute, that.setAttribute) &&
        Objects.equals(setAttributeInAllVariants, that.setAttributeInAllVariants) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setImageLabel, that.setImageLabel) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setMetaAttributes, that.setMetaAttributes) &&
        Objects.equals(setMetaDescription, that.setMetaDescription) &&
        Objects.equals(setMetaKeywords, that.setMetaKeywords) &&
        Objects.equals(setMetaTitle, that.setMetaTitle) &&
        Objects.equals(setProductPriceCustomField, that.setProductPriceCustomField) &&
        Objects.equals(setProductPriceCustomType, that.setProductPriceCustomType) &&
        Objects.equals(setPriceKey, that.setPriceKey) &&
        Objects.equals(setPriceMode, that.setPriceMode) &&
        Objects.equals(setPrices, that.setPrices) &&
        Objects.equals(setSku, that.setSku) &&
        Objects.equals(setTaxCategory, that.setTaxCategory) &&
        Objects.equals(setProductVariantKey, that.setProductVariantKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(moveImageToPosition, setSearchKeywords, revertStagedChanges, revertStagedVariantChanges, publish, unpublish, transitionState, removePrice, addAsset, addExternalImage, addPrice, addToCategory, addVariant, changeAssetName, changeAssetOrder, changeMasterVariant, changeImageLabel, changeName, changePrice, changeSlug, removeAsset, removeFromCategory, removeImage, removeVariant, setAssetCustomField, setAssetCustomType, setAssetDescription, setAssetKey, setAssetSources, setAssetTags, setCategoryOrderHint, setDiscountedPrice, setAttribute, setAttributeInAllVariants, setDescription, setImageLabel, setKey, setMetaAttributes, setMetaDescription, setMetaKeywords, setMetaTitle, setProductPriceCustomField, setProductPriceCustomType, setPriceKey, setPriceMode, setPrices, setSku, setTaxCategory, setProductVariantKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoveProductImageToPosition moveImageToPosition;

    private SetSearchKeywords setSearchKeywords;

    private RevertStagedChanges revertStagedChanges;

    private RevertStagedVariantChanges revertStagedVariantChanges;

    private PublishProduct publish;

    private UnpublishProduct unpublish;

    private TransitionProductState transitionState;

    private RemoveProductPrice removePrice;

    private AddProductAsset addAsset;

    private AddProductExternalImage addExternalImage;

    private AddProductPrice addPrice;

    private AddProductToCategory addToCategory;

    private AddProductVariant addVariant;

    private ChangeProductAssetName changeAssetName;

    private ChangeProductAssetOrder changeAssetOrder;

    private ChangeProductMasterVariant changeMasterVariant;

    private ChangeProductImageLabel changeImageLabel;

    private ChangeProductName changeName;

    private ChangeProductPrice changePrice;

    private ChangeProductSlug changeSlug;

    private RemoveProductAsset removeAsset;

    private RemoveProductFromCategory removeFromCategory;

    private RemoveProductImage removeImage;

    private RemoveProductVariant removeVariant;

    private SetProductAssetCustomField setAssetCustomField;

    private SetProductAssetCustomType setAssetCustomType;

    private SetProductAssetDescription setAssetDescription;

    private SetProductAssetKey setAssetKey;

    private SetProductAssetSources setAssetSources;

    private SetProductAssetTags setAssetTags;

    private SetProductCategoryOrderHint setCategoryOrderHint;

    private SetProductDiscountedPrice setDiscountedPrice;

    private SetProductAttribute setAttribute;

    private SetProductAttributeInAllVariants setAttributeInAllVariants;

    private SetProductDescription setDescription;

    private SetProductImageLabel setImageLabel;

    private SetProductKey setKey;

    private SetProductMetaAttributes setMetaAttributes;

    private SetProductMetaDescription setMetaDescription;

    private SetProductMetaKeywords setMetaKeywords;

    private SetProductMetaTitle setMetaTitle;

    private SetProductPriceCustomField setProductPriceCustomField;

    private SetProductPriceCustomType setProductPriceCustomType;

    private SetProductPriceKey setPriceKey;

    private SetProductPriceMode setPriceMode;

    private SetProductPrices setPrices;

    private SetProductSku setSku;

    private SetProductTaxCategory setTaxCategory;

    private SetProductVariantKey setProductVariantKey;

    public ProductUpdateAction build() {
      ProductUpdateAction result = new ProductUpdateAction();
      result.moveImageToPosition = this.moveImageToPosition;
      result.setSearchKeywords = this.setSearchKeywords;
      result.revertStagedChanges = this.revertStagedChanges;
      result.revertStagedVariantChanges = this.revertStagedVariantChanges;
      result.publish = this.publish;
      result.unpublish = this.unpublish;
      result.transitionState = this.transitionState;
      result.removePrice = this.removePrice;
      result.addAsset = this.addAsset;
      result.addExternalImage = this.addExternalImage;
      result.addPrice = this.addPrice;
      result.addToCategory = this.addToCategory;
      result.addVariant = this.addVariant;
      result.changeAssetName = this.changeAssetName;
      result.changeAssetOrder = this.changeAssetOrder;
      result.changeMasterVariant = this.changeMasterVariant;
      result.changeImageLabel = this.changeImageLabel;
      result.changeName = this.changeName;
      result.changePrice = this.changePrice;
      result.changeSlug = this.changeSlug;
      result.removeAsset = this.removeAsset;
      result.removeFromCategory = this.removeFromCategory;
      result.removeImage = this.removeImage;
      result.removeVariant = this.removeVariant;
      result.setAssetCustomField = this.setAssetCustomField;
      result.setAssetCustomType = this.setAssetCustomType;
      result.setAssetDescription = this.setAssetDescription;
      result.setAssetKey = this.setAssetKey;
      result.setAssetSources = this.setAssetSources;
      result.setAssetTags = this.setAssetTags;
      result.setCategoryOrderHint = this.setCategoryOrderHint;
      result.setDiscountedPrice = this.setDiscountedPrice;
      result.setAttribute = this.setAttribute;
      result.setAttributeInAllVariants = this.setAttributeInAllVariants;
      result.setDescription = this.setDescription;
      result.setImageLabel = this.setImageLabel;
      result.setKey = this.setKey;
      result.setMetaAttributes = this.setMetaAttributes;
      result.setMetaDescription = this.setMetaDescription;
      result.setMetaKeywords = this.setMetaKeywords;
      result.setMetaTitle = this.setMetaTitle;
      result.setProductPriceCustomField = this.setProductPriceCustomField;
      result.setProductPriceCustomType = this.setProductPriceCustomType;
      result.setPriceKey = this.setPriceKey;
      result.setPriceMode = this.setPriceMode;
      result.setPrices = this.setPrices;
      result.setSku = this.setSku;
      result.setTaxCategory = this.setTaxCategory;
      result.setProductVariantKey = this.setProductVariantKey;
      return result;
    }

    public Builder moveImageToPosition(MoveProductImageToPosition moveImageToPosition) {
      this.moveImageToPosition = moveImageToPosition;
      return this;
    }

    public Builder setSearchKeywords(SetSearchKeywords setSearchKeywords) {
      this.setSearchKeywords = setSearchKeywords;
      return this;
    }

    public Builder revertStagedChanges(RevertStagedChanges revertStagedChanges) {
      this.revertStagedChanges = revertStagedChanges;
      return this;
    }

    public Builder revertStagedVariantChanges(
        RevertStagedVariantChanges revertStagedVariantChanges) {
      this.revertStagedVariantChanges = revertStagedVariantChanges;
      return this;
    }

    public Builder publish(PublishProduct publish) {
      this.publish = publish;
      return this;
    }

    public Builder unpublish(UnpublishProduct unpublish) {
      this.unpublish = unpublish;
      return this;
    }

    public Builder transitionState(TransitionProductState transitionState) {
      this.transitionState = transitionState;
      return this;
    }

    public Builder removePrice(RemoveProductPrice removePrice) {
      this.removePrice = removePrice;
      return this;
    }

    public Builder addAsset(AddProductAsset addAsset) {
      this.addAsset = addAsset;
      return this;
    }

    public Builder addExternalImage(AddProductExternalImage addExternalImage) {
      this.addExternalImage = addExternalImage;
      return this;
    }

    public Builder addPrice(AddProductPrice addPrice) {
      this.addPrice = addPrice;
      return this;
    }

    public Builder addToCategory(AddProductToCategory addToCategory) {
      this.addToCategory = addToCategory;
      return this;
    }

    public Builder addVariant(AddProductVariant addVariant) {
      this.addVariant = addVariant;
      return this;
    }

    public Builder changeAssetName(ChangeProductAssetName changeAssetName) {
      this.changeAssetName = changeAssetName;
      return this;
    }

    public Builder changeAssetOrder(ChangeProductAssetOrder changeAssetOrder) {
      this.changeAssetOrder = changeAssetOrder;
      return this;
    }

    public Builder changeMasterVariant(ChangeProductMasterVariant changeMasterVariant) {
      this.changeMasterVariant = changeMasterVariant;
      return this;
    }

    public Builder changeImageLabel(ChangeProductImageLabel changeImageLabel) {
      this.changeImageLabel = changeImageLabel;
      return this;
    }

    public Builder changeName(ChangeProductName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changePrice(ChangeProductPrice changePrice) {
      this.changePrice = changePrice;
      return this;
    }

    public Builder changeSlug(ChangeProductSlug changeSlug) {
      this.changeSlug = changeSlug;
      return this;
    }

    public Builder removeAsset(RemoveProductAsset removeAsset) {
      this.removeAsset = removeAsset;
      return this;
    }

    public Builder removeFromCategory(RemoveProductFromCategory removeFromCategory) {
      this.removeFromCategory = removeFromCategory;
      return this;
    }

    public Builder removeImage(RemoveProductImage removeImage) {
      this.removeImage = removeImage;
      return this;
    }

    public Builder removeVariant(RemoveProductVariant removeVariant) {
      this.removeVariant = removeVariant;
      return this;
    }

    public Builder setAssetCustomField(SetProductAssetCustomField setAssetCustomField) {
      this.setAssetCustomField = setAssetCustomField;
      return this;
    }

    public Builder setAssetCustomType(SetProductAssetCustomType setAssetCustomType) {
      this.setAssetCustomType = setAssetCustomType;
      return this;
    }

    public Builder setAssetDescription(SetProductAssetDescription setAssetDescription) {
      this.setAssetDescription = setAssetDescription;
      return this;
    }

    public Builder setAssetKey(SetProductAssetKey setAssetKey) {
      this.setAssetKey = setAssetKey;
      return this;
    }

    public Builder setAssetSources(SetProductAssetSources setAssetSources) {
      this.setAssetSources = setAssetSources;
      return this;
    }

    public Builder setAssetTags(SetProductAssetTags setAssetTags) {
      this.setAssetTags = setAssetTags;
      return this;
    }

    public Builder setCategoryOrderHint(SetProductCategoryOrderHint setCategoryOrderHint) {
      this.setCategoryOrderHint = setCategoryOrderHint;
      return this;
    }

    public Builder setDiscountedPrice(SetProductDiscountedPrice setDiscountedPrice) {
      this.setDiscountedPrice = setDiscountedPrice;
      return this;
    }

    public Builder setAttribute(SetProductAttribute setAttribute) {
      this.setAttribute = setAttribute;
      return this;
    }

    public Builder setAttributeInAllVariants(
        SetProductAttributeInAllVariants setAttributeInAllVariants) {
      this.setAttributeInAllVariants = setAttributeInAllVariants;
      return this;
    }

    public Builder setDescription(SetProductDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setImageLabel(SetProductImageLabel setImageLabel) {
      this.setImageLabel = setImageLabel;
      return this;
    }

    public Builder setKey(SetProductKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setMetaAttributes(SetProductMetaAttributes setMetaAttributes) {
      this.setMetaAttributes = setMetaAttributes;
      return this;
    }

    public Builder setMetaDescription(SetProductMetaDescription setMetaDescription) {
      this.setMetaDescription = setMetaDescription;
      return this;
    }

    public Builder setMetaKeywords(SetProductMetaKeywords setMetaKeywords) {
      this.setMetaKeywords = setMetaKeywords;
      return this;
    }

    public Builder setMetaTitle(SetProductMetaTitle setMetaTitle) {
      this.setMetaTitle = setMetaTitle;
      return this;
    }

    public Builder setProductPriceCustomField(
        SetProductPriceCustomField setProductPriceCustomField) {
      this.setProductPriceCustomField = setProductPriceCustomField;
      return this;
    }

    public Builder setProductPriceCustomType(SetProductPriceCustomType setProductPriceCustomType) {
      this.setProductPriceCustomType = setProductPriceCustomType;
      return this;
    }

    public Builder setPriceKey(SetProductPriceKey setPriceKey) {
      this.setPriceKey = setPriceKey;
      return this;
    }

    public Builder setPriceMode(SetProductPriceMode setPriceMode) {
      this.setPriceMode = setPriceMode;
      return this;
    }

    public Builder setPrices(SetProductPrices setPrices) {
      this.setPrices = setPrices;
      return this;
    }

    public Builder setSku(SetProductSku setSku) {
      this.setSku = setSku;
      return this;
    }

    public Builder setTaxCategory(SetProductTaxCategory setTaxCategory) {
      this.setTaxCategory = setTaxCategory;
      return this;
    }

    public Builder setProductVariantKey(SetProductVariantKey setProductVariantKey) {
      this.setProductVariantKey = setProductVariantKey;
      return this;
    }
  }
}
