package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductVariantAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductVariant variant;

  private Boolean staged;

  private String type;

  public ProductVariantAdded() {
  }

  public ProductVariantAdded(ProductVariant variant, Boolean staged, String type) {
    this.variant = variant;
    this.staged = staged;
    this.type = type;
  }

  public ProductVariant getVariant() {
    return variant;
  }

  public void setVariant(ProductVariant variant) {
    this.variant = variant;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductVariantAdded{variant='" + variant + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantAdded that = (ProductVariantAdded) o;
    return Objects.equals(variant, that.variant) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variant, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductVariant variant;

    private Boolean staged;

    private String type;

    public ProductVariantAdded build() {
      ProductVariantAdded result = new ProductVariantAdded();
      result.variant = this.variant;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variant(ProductVariant variant) {
      this.variant = variant;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
