package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductVariantAvailabilityWithChannels {
  private ProductVariantAvailability noChannel;

  private ProductVariantAvailabilitiesResult channels;

  public ProductVariantAvailabilityWithChannels() {
  }

  public ProductVariantAvailabilityWithChannels(ProductVariantAvailability noChannel,
      ProductVariantAvailabilitiesResult channels) {
    this.noChannel = noChannel;
    this.channels = channels;
  }

  public ProductVariantAvailability getNoChannel() {
    return noChannel;
  }

  public void setNoChannel(ProductVariantAvailability noChannel) {
    this.noChannel = noChannel;
  }

  public ProductVariantAvailabilitiesResult getChannels() {
    return channels;
  }

  public void setChannels(ProductVariantAvailabilitiesResult channels) {
    this.channels = channels;
  }

  @Override
  public String toString() {
    return "ProductVariantAvailabilityWithChannels{noChannel='" + noChannel + "', channels='" + channels + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantAvailabilityWithChannels that = (ProductVariantAvailabilityWithChannels) o;
    return Objects.equals(noChannel, that.noChannel) &&
        Objects.equals(channels, that.channels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(noChannel, channels);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductVariantAvailability noChannel;

    private ProductVariantAvailabilitiesResult channels;

    public ProductVariantAvailabilityWithChannels build() {
      ProductVariantAvailabilityWithChannels result = new ProductVariantAvailabilityWithChannels();
      result.noChannel = this.noChannel;
      result.channels = this.channels;
      return result;
    }

    public Builder noChannel(ProductVariantAvailability noChannel) {
      this.noChannel = noChannel;
      return this;
    }

    public Builder channels(ProductVariantAvailabilitiesResult channels) {
      this.channels = channels;
      return this;
    }
  }
}
