package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductVariantExclusion {
  private List<String> skus;

  public ProductVariantExclusion() {
  }

  public ProductVariantExclusion(List<String> skus) {
    this.skus = skus;
  }

  public List<String> getSkus() {
    return skus;
  }

  public void setSkus(List<String> skus) {
    this.skus = skus;
  }

  @Override
  public String toString() {
    return "ProductVariantExclusion{skus='" + skus + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantExclusion that = (ProductVariantExclusion) o;
    return Objects.equals(skus, that.skus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(skus);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> skus;

    public ProductVariantExclusion build() {
      ProductVariantExclusion result = new ProductVariantExclusion();
      result.skus = this.skus;
      return result;
    }

    public Builder skus(List<String> skus) {
      this.skus = skus;
      return this;
    }
  }
}
