package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductVariantExclusionDraft {
  private List<String> skus;

  public ProductVariantExclusionDraft() {
  }

  public ProductVariantExclusionDraft(List<String> skus) {
    this.skus = skus;
  }

  public List<String> getSkus() {
    return skus;
  }

  public void setSkus(List<String> skus) {
    this.skus = skus;
  }

  @Override
  public String toString() {
    return "ProductVariantExclusionDraft{skus='" + skus + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantExclusionDraft that = (ProductVariantExclusionDraft) o;
    return Objects.equals(skus, that.skus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(skus);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> skus;

    public ProductVariantExclusionDraft build() {
      ProductVariantExclusionDraft result = new ProductVariantExclusionDraft();
      result.skus = this.skus;
      return result;
    }

    public Builder skus(List<String> skus) {
      this.skus = skus;
      return this;
    }
  }
}
