package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductVariantTailoring {
  private Integer id;

  private List<Image> images;

  private List<Asset> assets;

  private List<RawProductAttribute> attributesRaw;

  public ProductVariantTailoring() {
  }

  public ProductVariantTailoring(Integer id, List<Image> images, List<Asset> assets,
      List<RawProductAttribute> attributesRaw) {
    this.id = id;
    this.images = images;
    this.assets = assets;
    this.attributesRaw = attributesRaw;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public List<Image> getImages() {
    return images;
  }

  public void setImages(List<Image> images) {
    this.images = images;
  }

  public List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(List<Asset> assets) {
    this.assets = assets;
  }

  public List<RawProductAttribute> getAttributesRaw() {
    return attributesRaw;
  }

  public void setAttributesRaw(List<RawProductAttribute> attributesRaw) {
    this.attributesRaw = attributesRaw;
  }

  @Override
  public String toString() {
    return "ProductVariantTailoring{id='" + id + "', images='" + images + "', assets='" + assets + "', attributesRaw='" + attributesRaw + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantTailoring that = (ProductVariantTailoring) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(images, that.images) &&
        Objects.equals(assets, that.assets) &&
        Objects.equals(attributesRaw, that.attributesRaw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, images, assets, attributesRaw);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private List<Image> images;

    private List<Asset> assets;

    private List<RawProductAttribute> attributesRaw;

    public ProductVariantTailoring build() {
      ProductVariantTailoring result = new ProductVariantTailoring();
      result.id = this.id;
      result.images = this.images;
      result.assets = this.assets;
      result.attributesRaw = this.attributesRaw;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder images(List<Image> images) {
      this.images = images;
      return this;
    }

    public Builder assets(List<Asset> assets) {
      this.assets = assets;
      return this;
    }

    public Builder attributesRaw(List<RawProductAttribute> attributesRaw) {
      this.attributesRaw = attributesRaw;
      return this;
    }
  }
}
