package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductVariantTailoringAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private VariantTailoring variant;

  private String type;

  public ProductVariantTailoringAdded() {
  }

  public ProductVariantTailoringAdded(Integer variantId, KeyReference storeRef,
      Reference productRef, String productKey, VariantTailoring variant, String type) {
    this.variantId = variantId;
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.variant = variant;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public VariantTailoring getVariant() {
    return variant;
  }

  public void setVariant(VariantTailoring variant) {
    this.variant = variant;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductVariantTailoringAdded{variantId='" + variantId + "', storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', variant='" + variant + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantTailoringAdded that = (ProductVariantTailoringAdded) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(variant, that.variant) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, storeRef, productRef, productKey, variant, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private VariantTailoring variant;

    private String type;

    public ProductVariantTailoringAdded build() {
      ProductVariantTailoringAdded result = new ProductVariantTailoringAdded();
      result.variantId = this.variantId;
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.variant = this.variant;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder variant(VariantTailoring variant) {
      this.variant = variant;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
