package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductVariantTailoringInput {
  private Integer id;

  private String sku;

  private List<ImageInput> images = Collections.emptyList();

  private List<ProductAttributeInput> attributes = Collections.emptyList();

  private List<AssetDraftInput> assets = Collections.emptyList();

  public ProductVariantTailoringInput() {
  }

  public ProductVariantTailoringInput(Integer id, String sku, List<ImageInput> images,
      List<ProductAttributeInput> attributes, List<AssetDraftInput> assets) {
    this.id = id;
    this.sku = sku;
    this.images = images;
    this.attributes = attributes;
    this.assets = assets;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ImageInput> getImages() {
    return images;
  }

  public void setImages(List<ImageInput> images) {
    this.images = images;
  }

  public List<ProductAttributeInput> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<ProductAttributeInput> attributes) {
    this.attributes = attributes;
  }

  public List<AssetDraftInput> getAssets() {
    return assets;
  }

  public void setAssets(List<AssetDraftInput> assets) {
    this.assets = assets;
  }

  @Override
  public String toString() {
    return "ProductVariantTailoringInput{id='" + id + "', sku='" + sku + "', images='" + images + "', attributes='" + attributes + "', assets='" + assets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantTailoringInput that = (ProductVariantTailoringInput) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(images, that.images) &&
        Objects.equals(attributes, that.attributes) &&
        Objects.equals(assets, that.assets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sku, images, attributes, assets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private String sku;

    private List<ImageInput> images = Collections.emptyList();

    private List<ProductAttributeInput> attributes = Collections.emptyList();

    private List<AssetDraftInput> assets = Collections.emptyList();

    public ProductVariantTailoringInput build() {
      ProductVariantTailoringInput result = new ProductVariantTailoringInput();
      result.id = this.id;
      result.sku = this.sku;
      result.images = this.images;
      result.attributes = this.attributes;
      result.assets = this.assets;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder images(List<ImageInput> images) {
      this.images = images;
      return this;
    }

    public Builder attributes(List<ProductAttributeInput> attributes) {
      this.attributes = attributes;
      return this;
    }

    public Builder assets(List<AssetDraftInput> assets) {
      this.assets = assets;
      return this;
    }
  }
}
