package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * Contains information about the limits of your project.
 */
public class ProjectCustomLimitsProjection {
  private QueryLimitsProjection query;

  private ProductLimitsProjection products;

  private ShoppingListLimitsProjection shoppingLists;

  private ExtensionLimitsProjection extensions;

  private SubscriptionsLimitsProjection subscriptions;

  private ProductDiscountLimitsProjection productDiscounts;

  private CartDiscountLimitsProjection cartDiscounts;

  private OrderEditLimitsProjection orderEdits;

  private StoreLimitsProjection stores;

  private CustomerLimitsProjection customers;

  private CustomerGroupLimitsProjection customerGroups;

  private ZoneLimitsProjection zones;

  private TaxCategoryLimitsProjection taxCategories;

  private RefreshTokenLimitsProjection refreshTokens;

  private ShippingMethodLimitsProjection shippingMethods;

  private CartLimitsProjection carts;

  private CustomObjectLimitsProjection customObjects;

  private SearchLimitsProjection search;

  private CategoryLimitsProjection category;

  private ProductTypeLimitsProjection productType;

  public ProjectCustomLimitsProjection() {
  }

  public ProjectCustomLimitsProjection(QueryLimitsProjection query,
      ProductLimitsProjection products, ShoppingListLimitsProjection shoppingLists,
      ExtensionLimitsProjection extensions, SubscriptionsLimitsProjection subscriptions,
      ProductDiscountLimitsProjection productDiscounts, CartDiscountLimitsProjection cartDiscounts,
      OrderEditLimitsProjection orderEdits, StoreLimitsProjection stores,
      CustomerLimitsProjection customers, CustomerGroupLimitsProjection customerGroups,
      ZoneLimitsProjection zones, TaxCategoryLimitsProjection taxCategories,
      RefreshTokenLimitsProjection refreshTokens, ShippingMethodLimitsProjection shippingMethods,
      CartLimitsProjection carts, CustomObjectLimitsProjection customObjects,
      SearchLimitsProjection search, CategoryLimitsProjection category,
      ProductTypeLimitsProjection productType) {
    this.query = query;
    this.products = products;
    this.shoppingLists = shoppingLists;
    this.extensions = extensions;
    this.subscriptions = subscriptions;
    this.productDiscounts = productDiscounts;
    this.cartDiscounts = cartDiscounts;
    this.orderEdits = orderEdits;
    this.stores = stores;
    this.customers = customers;
    this.customerGroups = customerGroups;
    this.zones = zones;
    this.taxCategories = taxCategories;
    this.refreshTokens = refreshTokens;
    this.shippingMethods = shippingMethods;
    this.carts = carts;
    this.customObjects = customObjects;
    this.search = search;
    this.category = category;
    this.productType = productType;
  }

  public QueryLimitsProjection getQuery() {
    return query;
  }

  public void setQuery(QueryLimitsProjection query) {
    this.query = query;
  }

  public ProductLimitsProjection getProducts() {
    return products;
  }

  public void setProducts(ProductLimitsProjection products) {
    this.products = products;
  }

  public ShoppingListLimitsProjection getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListLimitsProjection shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  public ExtensionLimitsProjection getExtensions() {
    return extensions;
  }

  public void setExtensions(ExtensionLimitsProjection extensions) {
    this.extensions = extensions;
  }

  public SubscriptionsLimitsProjection getSubscriptions() {
    return subscriptions;
  }

  public void setSubscriptions(SubscriptionsLimitsProjection subscriptions) {
    this.subscriptions = subscriptions;
  }

  public ProductDiscountLimitsProjection getProductDiscounts() {
    return productDiscounts;
  }

  public void setProductDiscounts(ProductDiscountLimitsProjection productDiscounts) {
    this.productDiscounts = productDiscounts;
  }

  public CartDiscountLimitsProjection getCartDiscounts() {
    return cartDiscounts;
  }

  public void setCartDiscounts(CartDiscountLimitsProjection cartDiscounts) {
    this.cartDiscounts = cartDiscounts;
  }

  public OrderEditLimitsProjection getOrderEdits() {
    return orderEdits;
  }

  public void setOrderEdits(OrderEditLimitsProjection orderEdits) {
    this.orderEdits = orderEdits;
  }

  public StoreLimitsProjection getStores() {
    return stores;
  }

  public void setStores(StoreLimitsProjection stores) {
    this.stores = stores;
  }

  public CustomerLimitsProjection getCustomers() {
    return customers;
  }

  public void setCustomers(CustomerLimitsProjection customers) {
    this.customers = customers;
  }

  public CustomerGroupLimitsProjection getCustomerGroups() {
    return customerGroups;
  }

  public void setCustomerGroups(CustomerGroupLimitsProjection customerGroups) {
    this.customerGroups = customerGroups;
  }

  public ZoneLimitsProjection getZones() {
    return zones;
  }

  public void setZones(ZoneLimitsProjection zones) {
    this.zones = zones;
  }

  public TaxCategoryLimitsProjection getTaxCategories() {
    return taxCategories;
  }

  public void setTaxCategories(TaxCategoryLimitsProjection taxCategories) {
    this.taxCategories = taxCategories;
  }

  public RefreshTokenLimitsProjection getRefreshTokens() {
    return refreshTokens;
  }

  public void setRefreshTokens(RefreshTokenLimitsProjection refreshTokens) {
    this.refreshTokens = refreshTokens;
  }

  public ShippingMethodLimitsProjection getShippingMethods() {
    return shippingMethods;
  }

  public void setShippingMethods(ShippingMethodLimitsProjection shippingMethods) {
    this.shippingMethods = shippingMethods;
  }

  public CartLimitsProjection getCarts() {
    return carts;
  }

  public void setCarts(CartLimitsProjection carts) {
    this.carts = carts;
  }

  public CustomObjectLimitsProjection getCustomObjects() {
    return customObjects;
  }

  public void setCustomObjects(CustomObjectLimitsProjection customObjects) {
    this.customObjects = customObjects;
  }

  public SearchLimitsProjection getSearch() {
    return search;
  }

  public void setSearch(SearchLimitsProjection search) {
    this.search = search;
  }

  public CategoryLimitsProjection getCategory() {
    return category;
  }

  public void setCategory(CategoryLimitsProjection category) {
    this.category = category;
  }

  public ProductTypeLimitsProjection getProductType() {
    return productType;
  }

  public void setProductType(ProductTypeLimitsProjection productType) {
    this.productType = productType;
  }

  @Override
  public String toString() {
    return "ProjectCustomLimitsProjection{query='" + query + "', products='" + products + "', shoppingLists='" + shoppingLists + "', extensions='" + extensions + "', subscriptions='" + subscriptions + "', productDiscounts='" + productDiscounts + "', cartDiscounts='" + cartDiscounts + "', orderEdits='" + orderEdits + "', stores='" + stores + "', customers='" + customers + "', customerGroups='" + customerGroups + "', zones='" + zones + "', taxCategories='" + taxCategories + "', refreshTokens='" + refreshTokens + "', shippingMethods='" + shippingMethods + "', carts='" + carts + "', customObjects='" + customObjects + "', search='" + search + "', category='" + category + "', productType='" + productType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectCustomLimitsProjection that = (ProjectCustomLimitsProjection) o;
    return Objects.equals(query, that.query) &&
        Objects.equals(products, that.products) &&
        Objects.equals(shoppingLists, that.shoppingLists) &&
        Objects.equals(extensions, that.extensions) &&
        Objects.equals(subscriptions, that.subscriptions) &&
        Objects.equals(productDiscounts, that.productDiscounts) &&
        Objects.equals(cartDiscounts, that.cartDiscounts) &&
        Objects.equals(orderEdits, that.orderEdits) &&
        Objects.equals(stores, that.stores) &&
        Objects.equals(customers, that.customers) &&
        Objects.equals(customerGroups, that.customerGroups) &&
        Objects.equals(zones, that.zones) &&
        Objects.equals(taxCategories, that.taxCategories) &&
        Objects.equals(refreshTokens, that.refreshTokens) &&
        Objects.equals(shippingMethods, that.shippingMethods) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(customObjects, that.customObjects) &&
        Objects.equals(search, that.search) &&
        Objects.equals(category, that.category) &&
        Objects.equals(productType, that.productType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, products, shoppingLists, extensions, subscriptions, productDiscounts, cartDiscounts, orderEdits, stores, customers, customerGroups, zones, taxCategories, refreshTokens, shippingMethods, carts, customObjects, search, category, productType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QueryLimitsProjection query;

    private ProductLimitsProjection products;

    private ShoppingListLimitsProjection shoppingLists;

    private ExtensionLimitsProjection extensions;

    private SubscriptionsLimitsProjection subscriptions;

    private ProductDiscountLimitsProjection productDiscounts;

    private CartDiscountLimitsProjection cartDiscounts;

    private OrderEditLimitsProjection orderEdits;

    private StoreLimitsProjection stores;

    private CustomerLimitsProjection customers;

    private CustomerGroupLimitsProjection customerGroups;

    private ZoneLimitsProjection zones;

    private TaxCategoryLimitsProjection taxCategories;

    private RefreshTokenLimitsProjection refreshTokens;

    private ShippingMethodLimitsProjection shippingMethods;

    private CartLimitsProjection carts;

    private CustomObjectLimitsProjection customObjects;

    private SearchLimitsProjection search;

    private CategoryLimitsProjection category;

    private ProductTypeLimitsProjection productType;

    public ProjectCustomLimitsProjection build() {
      ProjectCustomLimitsProjection result = new ProjectCustomLimitsProjection();
      result.query = this.query;
      result.products = this.products;
      result.shoppingLists = this.shoppingLists;
      result.extensions = this.extensions;
      result.subscriptions = this.subscriptions;
      result.productDiscounts = this.productDiscounts;
      result.cartDiscounts = this.cartDiscounts;
      result.orderEdits = this.orderEdits;
      result.stores = this.stores;
      result.customers = this.customers;
      result.customerGroups = this.customerGroups;
      result.zones = this.zones;
      result.taxCategories = this.taxCategories;
      result.refreshTokens = this.refreshTokens;
      result.shippingMethods = this.shippingMethods;
      result.carts = this.carts;
      result.customObjects = this.customObjects;
      result.search = this.search;
      result.category = this.category;
      result.productType = this.productType;
      return result;
    }

    public Builder query(QueryLimitsProjection query) {
      this.query = query;
      return this;
    }

    public Builder products(ProductLimitsProjection products) {
      this.products = products;
      return this;
    }

    public Builder shoppingLists(ShoppingListLimitsProjection shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }

    public Builder extensions(ExtensionLimitsProjection extensions) {
      this.extensions = extensions;
      return this;
    }

    public Builder subscriptions(SubscriptionsLimitsProjection subscriptions) {
      this.subscriptions = subscriptions;
      return this;
    }

    public Builder productDiscounts(ProductDiscountLimitsProjection productDiscounts) {
      this.productDiscounts = productDiscounts;
      return this;
    }

    public Builder cartDiscounts(CartDiscountLimitsProjection cartDiscounts) {
      this.cartDiscounts = cartDiscounts;
      return this;
    }

    public Builder orderEdits(OrderEditLimitsProjection orderEdits) {
      this.orderEdits = orderEdits;
      return this;
    }

    public Builder stores(StoreLimitsProjection stores) {
      this.stores = stores;
      return this;
    }

    public Builder customers(CustomerLimitsProjection customers) {
      this.customers = customers;
      return this;
    }

    public Builder customerGroups(CustomerGroupLimitsProjection customerGroups) {
      this.customerGroups = customerGroups;
      return this;
    }

    public Builder zones(ZoneLimitsProjection zones) {
      this.zones = zones;
      return this;
    }

    public Builder taxCategories(TaxCategoryLimitsProjection taxCategories) {
      this.taxCategories = taxCategories;
      return this;
    }

    public Builder refreshTokens(RefreshTokenLimitsProjection refreshTokens) {
      this.refreshTokens = refreshTokens;
      return this;
    }

    public Builder shippingMethods(ShippingMethodLimitsProjection shippingMethods) {
      this.shippingMethods = shippingMethods;
      return this;
    }

    public Builder carts(CartLimitsProjection carts) {
      this.carts = carts;
      return this;
    }

    public Builder customObjects(CustomObjectLimitsProjection customObjects) {
      this.customObjects = customObjects;
      return this;
    }

    public Builder search(SearchLimitsProjection search) {
      this.search = search;
      return this;
    }

    public Builder category(CategoryLimitsProjection category) {
      this.category = category;
      return this;
    }

    public Builder productType(ProductTypeLimitsProjection productType) {
      this.productType = productType;
      return this;
    }
  }
}
