package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

/**
 * Project contains information about project.
 */
public class ProjectProjection {
  private String key;

  private String name;

  private List<String> languages;

  private OffsetDateTime createdAt;

  private String trialUntil;

  private CartsConfiguration carts;

  private ShoppingListsConfiguration shoppingLists;

  private Long version;

  private ExternalOAuth externalOAuth;

  private SearchIndexingConfiguration searchIndexing;

  private MessagesConfiguration messages;

  private List<String> countries;

  private List<Currency> currencies;

  private ShippingRateInputType shippingRateInputType;

  public ProjectProjection() {
  }

  public ProjectProjection(String key, String name, List<String> languages,
      OffsetDateTime createdAt, String trialUntil, CartsConfiguration carts,
      ShoppingListsConfiguration shoppingLists, Long version, ExternalOAuth externalOAuth,
      SearchIndexingConfiguration searchIndexing, MessagesConfiguration messages,
      List<String> countries, List<Currency> currencies,
      ShippingRateInputType shippingRateInputType) {
    this.key = key;
    this.name = name;
    this.languages = languages;
    this.createdAt = createdAt;
    this.trialUntil = trialUntil;
    this.carts = carts;
    this.shoppingLists = shoppingLists;
    this.version = version;
    this.externalOAuth = externalOAuth;
    this.searchIndexing = searchIndexing;
    this.messages = messages;
    this.countries = countries;
    this.currencies = currencies;
    this.shippingRateInputType = shippingRateInputType;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<String> getLanguages() {
    return languages;
  }

  public void setLanguages(List<String> languages) {
    this.languages = languages;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public String getTrialUntil() {
    return trialUntil;
  }

  public void setTrialUntil(String trialUntil) {
    this.trialUntil = trialUntil;
  }

  public CartsConfiguration getCarts() {
    return carts;
  }

  public void setCarts(CartsConfiguration carts) {
    this.carts = carts;
  }

  public ShoppingListsConfiguration getShoppingLists() {
    return shoppingLists;
  }

  public void setShoppingLists(ShoppingListsConfiguration shoppingLists) {
    this.shoppingLists = shoppingLists;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public ExternalOAuth getExternalOAuth() {
    return externalOAuth;
  }

  public void setExternalOAuth(ExternalOAuth externalOAuth) {
    this.externalOAuth = externalOAuth;
  }

  public SearchIndexingConfiguration getSearchIndexing() {
    return searchIndexing;
  }

  public void setSearchIndexing(SearchIndexingConfiguration searchIndexing) {
    this.searchIndexing = searchIndexing;
  }

  public MessagesConfiguration getMessages() {
    return messages;
  }

  public void setMessages(MessagesConfiguration messages) {
    this.messages = messages;
  }

  public List<String> getCountries() {
    return countries;
  }

  public void setCountries(List<String> countries) {
    this.countries = countries;
  }

  public List<Currency> getCurrencies() {
    return currencies;
  }

  public void setCurrencies(List<Currency> currencies) {
    this.currencies = currencies;
  }

  public ShippingRateInputType getShippingRateInputType() {
    return shippingRateInputType;
  }

  public void setShippingRateInputType(ShippingRateInputType shippingRateInputType) {
    this.shippingRateInputType = shippingRateInputType;
  }

  @Override
  public String toString() {
    return "ProjectProjection{key='" + key + "', name='" + name + "', languages='" + languages + "', createdAt='" + createdAt + "', trialUntil='" + trialUntil + "', carts='" + carts + "', shoppingLists='" + shoppingLists + "', version='" + version + "', externalOAuth='" + externalOAuth + "', searchIndexing='" + searchIndexing + "', messages='" + messages + "', countries='" + countries + "', currencies='" + currencies + "', shippingRateInputType='" + shippingRateInputType + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectProjection that = (ProjectProjection) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(languages, that.languages) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(trialUntil, that.trialUntil) &&
        Objects.equals(carts, that.carts) &&
        Objects.equals(shoppingLists, that.shoppingLists) &&
        Objects.equals(version, that.version) &&
        Objects.equals(externalOAuth, that.externalOAuth) &&
        Objects.equals(searchIndexing, that.searchIndexing) &&
        Objects.equals(messages, that.messages) &&
        Objects.equals(countries, that.countries) &&
        Objects.equals(currencies, that.currencies) &&
        Objects.equals(shippingRateInputType, that.shippingRateInputType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, languages, createdAt, trialUntil, carts, shoppingLists, version, externalOAuth, searchIndexing, messages, countries, currencies, shippingRateInputType);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private List<String> languages;

    private OffsetDateTime createdAt;

    private String trialUntil;

    private CartsConfiguration carts;

    private ShoppingListsConfiguration shoppingLists;

    private Long version;

    private ExternalOAuth externalOAuth;

    private SearchIndexingConfiguration searchIndexing;

    private MessagesConfiguration messages;

    private List<String> countries;

    private List<Currency> currencies;

    private ShippingRateInputType shippingRateInputType;

    public ProjectProjection build() {
      ProjectProjection result = new ProjectProjection();
      result.key = this.key;
      result.name = this.name;
      result.languages = this.languages;
      result.createdAt = this.createdAt;
      result.trialUntil = this.trialUntil;
      result.carts = this.carts;
      result.shoppingLists = this.shoppingLists;
      result.version = this.version;
      result.externalOAuth = this.externalOAuth;
      result.searchIndexing = this.searchIndexing;
      result.messages = this.messages;
      result.countries = this.countries;
      result.currencies = this.currencies;
      result.shippingRateInputType = this.shippingRateInputType;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder languages(List<String> languages) {
      this.languages = languages;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder trialUntil(String trialUntil) {
      this.trialUntil = trialUntil;
      return this;
    }

    public Builder carts(CartsConfiguration carts) {
      this.carts = carts;
      return this;
    }

    public Builder shoppingLists(ShoppingListsConfiguration shoppingLists) {
      this.shoppingLists = shoppingLists;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder externalOAuth(ExternalOAuth externalOAuth) {
      this.externalOAuth = externalOAuth;
      return this;
    }

    public Builder searchIndexing(SearchIndexingConfiguration searchIndexing) {
      this.searchIndexing = searchIndexing;
      return this;
    }

    public Builder messages(MessagesConfiguration messages) {
      this.messages = messages;
      return this;
    }

    public Builder countries(List<String> countries) {
      this.countries = countries;
      return this;
    }

    public Builder currencies(List<Currency> currencies) {
      this.currencies = currencies;
      return this;
    }

    public Builder shippingRateInputType(ShippingRateInputType shippingRateInputType) {
      this.shippingRateInputType = shippingRateInputType;
      return this;
    }
  }
}
