package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PublishProduct {
  private PublishScope scope;

  public PublishProduct() {
  }

  public PublishProduct(PublishScope scope) {
    this.scope = scope;
  }

  public PublishScope getScope() {
    return scope;
  }

  public void setScope(PublishScope scope) {
    this.scope = scope;
  }

  @Override
  public String toString() {
    return "PublishProduct{scope='" + scope + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PublishProduct that = (PublishProduct) o;
    return Objects.equals(scope, that.scope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scope);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PublishScope scope;

    public PublishProduct build() {
      PublishProduct result = new PublishProduct();
      result.scope = this.scope;
      return result;
    }

    public Builder scope(PublishScope scope) {
      this.scope = scope;
      return this;
    }
  }
}
