package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteCustomerChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private Reference customerRef;

  private Reference previousCustomerRef;

  private Customer customer;

  private Customer previousCustomer;

  private String type;

  public QuoteCustomerChanged() {
  }

  public QuoteCustomerChanged(Reference customerRef, Reference previousCustomerRef,
      Customer customer, Customer previousCustomer, String type) {
    this.customerRef = customerRef;
    this.previousCustomerRef = previousCustomerRef;
    this.customer = customer;
    this.previousCustomer = previousCustomer;
    this.type = type;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Reference getPreviousCustomerRef() {
    return previousCustomerRef;
  }

  public void setPreviousCustomerRef(Reference previousCustomerRef) {
    this.previousCustomerRef = previousCustomerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public Customer getPreviousCustomer() {
    return previousCustomer;
  }

  public void setPreviousCustomer(Customer previousCustomer) {
    this.previousCustomer = previousCustomer;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteCustomerChanged{customerRef='" + customerRef + "', previousCustomerRef='" + previousCustomerRef + "', customer='" + customer + "', previousCustomer='" + previousCustomer + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteCustomerChanged that = (QuoteCustomerChanged) o;
    return Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(previousCustomerRef, that.previousCustomerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(previousCustomer, that.previousCustomer) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerRef, previousCustomerRef, customer, previousCustomer, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference customerRef;

    private Reference previousCustomerRef;

    private Customer customer;

    private Customer previousCustomer;

    private String type;

    public QuoteCustomerChanged build() {
      QuoteCustomerChanged result = new QuoteCustomerChanged();
      result.customerRef = this.customerRef;
      result.previousCustomerRef = this.previousCustomerRef;
      result.customer = this.customer;
      result.previousCustomer = this.previousCustomer;
      result.type = this.type;
      return result;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder previousCustomerRef(Reference previousCustomerRef) {
      this.previousCustomerRef = previousCustomerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder previousCustomer(Customer previousCustomer) {
      this.previousCustomer = previousCustomer;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
