package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteRenegotiationRequested implements com.commercetools.graphql.api.types.MessagePayload {
  private String buyerComment;

  private String type;

  public QuoteRenegotiationRequested() {
  }

  public QuoteRenegotiationRequested(String buyerComment, String type) {
    this.buyerComment = buyerComment;
    this.type = type;
  }

  public String getBuyerComment() {
    return buyerComment;
  }

  public void setBuyerComment(String buyerComment) {
    this.buyerComment = buyerComment;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteRenegotiationRequested{buyerComment='" + buyerComment + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRenegotiationRequested that = (QuoteRenegotiationRequested) o;
    return Objects.equals(buyerComment, that.buyerComment) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(buyerComment, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String buyerComment;

    private String type;

    public QuoteRenegotiationRequested build() {
      QuoteRenegotiationRequested result = new QuoteRenegotiationRequested();
      result.buyerComment = this.buyerComment;
      result.type = this.type;
      return result;
    }

    public Builder buyerComment(String buyerComment) {
      this.buyerComment = buyerComment;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
